/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.sdo.objects;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.common.StixBoolean;
import security.whisper.javastix.common.StixCommonProperties;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.common.StixLabels;
import security.whisper.javastix.common.StixModified;
import security.whisper.javastix.common.StixRevoked;
import security.whisper.javastix.datamarkings.GranularMarkingDm;
import security.whisper.javastix.datamarkings.MarkingDefinitionDm;
import security.whisper.javastix.json.converters.dehydrated.BundleableObjectSetConverter;
import security.whisper.javastix.json.converters.dehydrated.DomainObjectOptionalConverter;
import security.whisper.javastix.json.converters.dehydrated.MarkingDefinitionSetConverter;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.DomainObject;
import security.whisper.javastix.sdo.objects.IdentitySdo;
import security.whisper.javastix.sdo.objects.ReportSdo;
import security.whisper.javastix.sdo.types.ExternalReferenceType;
import security.whisper.javastix.sro.objects.RelationshipSro;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonTypeName(value="report")
@Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
@Generated(from="ReportSdo", generator="Immutables")
@Immutable
public final class Report
implements ReportSdo {
    private final ImmutableSet<String> labels;
    private final String name;
    @Nullable
    private final String description;
    private final StixInstant published;
    private final ImmutableSet<BundleableObject> objectRefs;
    private final ImmutableSet<RelationshipSro> relationships;
    private final boolean hydrated;
    private final String type;
    private final String id;
    @Nullable
    private final IdentitySdo createdByRef;
    private final StixInstant created;
    @Nullable
    private final String lang;
    private final ImmutableSet<ExternalReferenceType> externalReferences;
    private final ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;
    private final ImmutableSet<GranularMarkingDm> granularMarkings;
    private final ImmutableMap<String, Object> customProperties;
    private final StixInstant modified;
    private final StixBoolean revoked;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long TO_JSON_STRING_LAZY_INIT_BIT = 1L;
    private transient String toJsonString;
    private static final long SPEC_VERSION_LAZY_INIT_BIT = 2L;
    private transient String specVersion;
    private static final long serialVersionUID = 1L;

    private Report(Builder builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.published = builder.published;
        this.type = builder.type;
        this.id = builder.id;
        this.createdByRef = builder.createdByRef;
        this.lang = builder.lang;
        this.customProperties = builder.customProperties.build();
        if (builder.labelsIsSet()) {
            this.initShim.labels((ImmutableSet<String>)builder.labels.build());
        }
        if (builder.objectRefsIsSet()) {
            this.initShim.objectRefs((ImmutableSet<BundleableObject>)builder.objectRefs.build());
        }
        if (builder.relationshipsIsSet()) {
            this.initShim.relationships((ImmutableSet<RelationshipSro>)builder.relationships.build());
        }
        if (builder.hydratedIsSet()) {
            this.initShim.hydrated(builder.hydrated);
        }
        if (builder.created != null) {
            this.initShim.created(builder.created);
        }
        if (builder.externalReferencesIsSet()) {
            this.initShim.externalReferences((ImmutableSet<ExternalReferenceType>)builder.externalReferences.build());
        }
        if (builder.objectMarkingRefsIsSet()) {
            this.initShim.objectMarkingRefs((ImmutableSet<MarkingDefinitionDm>)builder.objectMarkingRefs.build());
        }
        if (builder.granularMarkingsIsSet()) {
            this.initShim.granularMarkings((ImmutableSet<GranularMarkingDm>)builder.granularMarkings.build());
        }
        if (builder.modified != null) {
            this.initShim.modified(builder.modified);
        }
        if (builder.revoked != null) {
            this.initShim.revoked(builder.revoked);
        }
        this.labels = this.initShim.getLabels();
        this.objectRefs = this.initShim.getObjectRefs();
        this.relationships = this.initShim.getRelationships();
        this.hydrated = this.initShim.getHydrated();
        this.created = this.initShim.getCreated();
        this.externalReferences = this.initShim.getExternalReferences();
        this.objectMarkingRefs = this.initShim.getObjectMarkingRefs();
        this.granularMarkings = this.initShim.getGranularMarkings();
        this.modified = this.initShim.getModified();
        this.revoked = this.initShim.getRevoked();
        this.initShim = null;
    }

    private Report(ImmutableSet<String> labels, String name, @Nullable String description, StixInstant published, ImmutableSet<BundleableObject> objectRefs, ImmutableSet<RelationshipSro> relationships, boolean hydrated, String type, String id, @Nullable IdentitySdo createdByRef, StixInstant created, @Nullable String lang, ImmutableSet<ExternalReferenceType> externalReferences, ImmutableSet<MarkingDefinitionDm> objectMarkingRefs, ImmutableSet<GranularMarkingDm> granularMarkings, ImmutableMap<String, Object> customProperties, StixInstant modified, StixBoolean revoked) {
        this.labels = labels;
        this.name = name;
        this.description = description;
        this.published = published;
        this.objectRefs = objectRefs;
        this.relationships = relationships;
        this.hydrated = hydrated;
        this.type = type;
        this.id = id;
        this.createdByRef = createdByRef;
        this.created = created;
        this.lang = lang;
        this.externalReferences = externalReferences;
        this.objectMarkingRefs = objectMarkingRefs;
        this.granularMarkings = granularMarkings;
        this.customProperties = customProperties;
        this.modified = modified;
        this.revoked = revoked;
        this.initShim = null;
    }

    private Set<String> getLabelsInitialize() {
        return ReportSdo.super.getLabels();
    }

    private Set<BundleableObject> getObjectRefsInitialize() {
        return ReportSdo.super.getObjectRefs();
    }

    private Set<RelationshipSro> getRelationshipsInitialize() {
        return ReportSdo.super.getRelationships();
    }

    private boolean getHydratedInitialize() {
        return ReportSdo.super.getHydrated();
    }

    private StixInstant getCreatedInitialize() {
        return ReportSdo.super.getCreated();
    }

    private Set<ExternalReferenceType> getExternalReferencesInitialize() {
        return ReportSdo.super.getExternalReferences();
    }

    private Set<MarkingDefinitionDm> getObjectMarkingRefsInitialize() {
        return ReportSdo.super.getObjectMarkingRefs();
    }

    private Set<GranularMarkingDm> getGranularMarkingsInitialize() {
        return ReportSdo.super.getGranularMarkings();
    }

    private StixInstant getModifiedInitialize() {
        return ReportSdo.super.getModified();
    }

    private StixBoolean getRevokedInitialize() {
        return ReportSdo.super.getRevoked();
    }

    @JsonProperty(value="labels")
    @JsonPropertyDescription(value="This field is an Open Vocabulary that specifies the primary subject of this report. The suggested values for this field are in report-label-ov.")
    @Redactable(useMask=true, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<String> getLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getLabels() : this.labels;
    }

    @Override
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="A description that provides more details and context about Report.")
    @Redactable(useMask=true, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A description that provides more details and context about Report.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty(value="published")
    @JsonPropertyDescription(value="The date that this report object was officially published by the creator of this report.")
    @Redactable(useMask=true, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public StixInstant getPublished() {
        return this.published;
    }

    @JsonProperty(value="object_refs")
    @JsonPropertyDescription(value="Specifies the STIX Objects that are referred to by this Report.")
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    @JsonDeserialize(converter=BundleableObjectSetConverter.class)
    @Redactable(useMask=true, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<BundleableObject> getObjectRefs() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getObjectRefs() : this.objectRefs;
    }

    @JsonProperty(value="relationships")
    @JsonIgnore
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<RelationshipSro> getRelationships() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRelationships() : this.relationships;
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public boolean getHydrated() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getHydrated() : this.hydrated;
    }

    @Override
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="The type property identifies the type of STIX Object (SDO, Relationship Object, etc). The value of the type field MUST be one of the types defined by a STIX Object (e.g., indicator).")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="created_by_ref")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    @JsonDeserialize(converter=DomainObjectOptionalConverter.class)
    @Redactable(useMask=true, redactionMask="identity--__REDACTED__")
    public Optional<IdentitySdo> getCreatedByRef() {
        return Optional.ofNullable(this.createdByRef);
    }

    @Override
    @JsonProperty(value="created")
    @JsonPropertyDescription(value="The created property represents the time at which the first version of this object was created. The timstamp value MUST be precise to the nearest millisecond.")
    @Redactable(useMask=true, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public StixInstant getCreated() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCreated() : this.created;
    }

    @Override
    @JsonProperty(value="lang")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Identifies the language of the text content in this object using ISO 639-2 language codes.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<String> getLang() {
        return Optional.ofNullable(this.lang);
    }

    @JsonProperty(value="external_references")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A list of external references which refers to non-STIX information.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<ExternalReferenceType> getExternalReferences() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getExternalReferences() : this.externalReferences;
    }

    @JsonProperty(value="object_marking_refs")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The list of marking-definition objects to be applied to this object.")
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    @JsonDeserialize(converter=MarkingDefinitionSetConverter.class)
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getObjectMarkingRefs() : this.objectMarkingRefs;
    }

    @JsonProperty(value="granular_markings")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The set of granular markings that apply to this object.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<GranularMarkingDm> getGranularMarkings() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getGranularMarkings() : this.granularMarkings;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    @Override
    @JsonProperty(value="modified")
    @JsonPropertyDescription(value="The modified property represents the time that this particular version of the object was created. The timstamp value MUST be precise to the nearest millisecond.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public StixInstant getModified() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getModified() : this.modified;
    }

    @Override
    @JsonProperty(value="revoked")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The revoked property indicates whether the object has been revoked.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public StixBoolean getRevoked() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRevoked() : this.revoked;
    }

    public final Report withLabels(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return Report.validate(new Report((ImmutableSet<String>)newValue, this.name, this.description, this.published, this.objectRefs, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Report withLabels(Iterable<String> elements) {
        if (this.labels == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return Report.validate(new Report((ImmutableSet<String>)newValue, this.name, this.description, this.published, this.objectRefs, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Report withName(String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return Report.validate(new Report(this.labels, value, this.description, this.published, this.objectRefs, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Report withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return Report.validate(new Report(this.labels, this.name, newValue, this.published, this.objectRefs, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Report withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return Report.validate(new Report(this.labels, this.name, value, this.published, this.objectRefs, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Report withPublished(StixInstant value) {
        if (this.published == value) {
            return this;
        }
        return Report.validate(new Report(this.labels, this.name, this.description, value, this.objectRefs, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Report withObjectRefs(BundleableObject ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return Report.validate(new Report(this.labels, this.name, this.description, this.published, (ImmutableSet<BundleableObject>)newValue, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Report withObjectRefs(Iterable<? extends BundleableObject> elements) {
        if (this.objectRefs == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return Report.validate(new Report(this.labels, this.name, this.description, this.published, (ImmutableSet<BundleableObject>)newValue, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Report withRelationships(RelationshipSro ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return Report.validate(new Report(this.labels, this.name, this.description, this.published, this.objectRefs, (ImmutableSet<RelationshipSro>)newValue, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Report withRelationships(Iterable<? extends RelationshipSro> elements) {
        if (this.relationships == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return Report.validate(new Report(this.labels, this.name, this.description, this.published, this.objectRefs, (ImmutableSet<RelationshipSro>)newValue, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Report withHydrated(boolean value) {
        if (this.hydrated == value) {
            return this;
        }
        return Report.validate(new Report(this.labels, this.name, this.description, this.published, this.objectRefs, this.relationships, value, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Report withType(String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return Report.validate(new Report(this.labels, this.name, this.description, this.published, this.objectRefs, this.relationships, this.hydrated, value, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Report withId(String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return Report.validate(new Report(this.labels, this.name, this.description, this.published, this.objectRefs, this.relationships, this.hydrated, this.type, value, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Report withCreatedByRef(IdentitySdo value) {
        IdentitySdo newValue = Objects.requireNonNull(value, "createdByRef");
        if (this.createdByRef == newValue) {
            return this;
        }
        return Report.validate(new Report(this.labels, this.name, this.description, this.published, this.objectRefs, this.relationships, this.hydrated, this.type, this.id, newValue, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Report withCreatedByRef(Optional<? extends IdentitySdo> optional) {
        IdentitySdo value = optional.orElse(null);
        if (this.createdByRef == value) {
            return this;
        }
        return Report.validate(new Report(this.labels, this.name, this.description, this.published, this.objectRefs, this.relationships, this.hydrated, this.type, this.id, value, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Report withCreated(StixInstant value) {
        if (this.created == value) {
            return this;
        }
        StixInstant newValue = Objects.requireNonNull(value, "created");
        return Report.validate(new Report(this.labels, this.name, this.description, this.published, this.objectRefs, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, newValue, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Report withLang(String value) {
        String newValue = Objects.requireNonNull(value, "lang");
        if (Objects.equals(this.lang, newValue)) {
            return this;
        }
        return Report.validate(new Report(this.labels, this.name, this.description, this.published, this.objectRefs, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, newValue, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Report withLang(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.lang, value)) {
            return this;
        }
        return Report.validate(new Report(this.labels, this.name, this.description, this.published, this.objectRefs, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, value, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Report withExternalReferences(ExternalReferenceType ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return Report.validate(new Report(this.labels, this.name, this.description, this.published, this.objectRefs, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, (ImmutableSet<ExternalReferenceType>)newValue, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Report withExternalReferences(Iterable<? extends ExternalReferenceType> elements) {
        if (this.externalReferences == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return Report.validate(new Report(this.labels, this.name, this.description, this.published, this.objectRefs, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, (ImmutableSet<ExternalReferenceType>)newValue, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Report withObjectMarkingRefs(MarkingDefinitionDm ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return Report.validate(new Report(this.labels, this.name, this.description, this.published, this.objectRefs, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, (ImmutableSet<MarkingDefinitionDm>)newValue, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Report withObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
        if (this.objectMarkingRefs == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return Report.validate(new Report(this.labels, this.name, this.description, this.published, this.objectRefs, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, (ImmutableSet<MarkingDefinitionDm>)newValue, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Report withGranularMarkings(GranularMarkingDm ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return Report.validate(new Report(this.labels, this.name, this.description, this.published, this.objectRefs, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, (ImmutableSet<GranularMarkingDm>)newValue, this.customProperties, this.modified, this.revoked));
    }

    public final Report withGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
        if (this.granularMarkings == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return Report.validate(new Report(this.labels, this.name, this.description, this.published, this.objectRefs, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, (ImmutableSet<GranularMarkingDm>)newValue, this.customProperties, this.modified, this.revoked));
    }

    public final Report withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return Report.validate(new Report(this.labels, this.name, this.description, this.published, this.objectRefs, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, (ImmutableMap<String, Object>)newValue, this.modified, this.revoked));
    }

    public final Report withModified(StixInstant value) {
        if (this.modified == value) {
            return this;
        }
        StixInstant newValue = Objects.requireNonNull(value, "modified");
        return Report.validate(new Report(this.labels, this.name, this.description, this.published, this.objectRefs, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, newValue, this.revoked));
    }

    public final Report withRevoked(StixBoolean value) {
        if (this.revoked == value) {
            return this;
        }
        StixBoolean newValue = Objects.requireNonNull(value, "revoked");
        return Report.validate(new Report(this.labels, this.name, this.description, this.published, this.objectRefs, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Report && this.equalTo((Report)another);
    }

    private boolean equalTo(Report another) {
        return this.labels.equals(another.labels) && Objects.equals(this.name, another.name) && Objects.equals(this.description, another.description) && Objects.equals(this.published, another.published) && this.objectRefs.equals(another.objectRefs) && this.relationships.equals(another.relationships) && this.hydrated == another.hydrated && Objects.equals(this.type, another.type) && Objects.equals(this.id, another.id) && Objects.equals(this.createdByRef, another.createdByRef) && this.created.equals(another.created) && Objects.equals(this.lang, another.lang) && this.externalReferences.equals(another.externalReferences) && this.objectMarkingRefs.equals(another.objectMarkingRefs) && this.granularMarkings.equals(another.granularMarkings) && this.customProperties.equals(another.customProperties) && this.modified.equals(another.modified) && this.revoked.equals(another.revoked);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.labels.hashCode();
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.published);
        h += (h << 5) + this.objectRefs.hashCode();
        h += (h << 5) + this.relationships.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.hydrated);
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.createdByRef);
        h += (h << 5) + this.created.hashCode();
        h += (h << 5) + Objects.hashCode(this.lang);
        h += (h << 5) + this.externalReferences.hashCode();
        h += (h << 5) + this.objectMarkingRefs.hashCode();
        h += (h << 5) + this.granularMarkings.hashCode();
        h += (h << 5) + this.customProperties.hashCode();
        h += (h << 5) + this.modified.hashCode();
        h += (h << 5) + this.revoked.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Report").omitNullValues().add("labels", this.labels).add("name", (Object)this.name).add("description", (Object)this.description).add("published", (Object)this.published).add("objectRefs", this.objectRefs).add("relationships", this.relationships).add("hydrated", this.hydrated).add("type", (Object)this.type).add("id", (Object)this.id).add("createdByRef", (Object)this.createdByRef).add("created", (Object)this.created).add("lang", (Object)this.lang).add("externalReferences", this.externalReferences).add("objectMarkingRefs", this.objectMarkingRefs).add("granularMarkings", this.granularMarkings).add("customProperties", this.customProperties).add("modified", (Object)this.modified).add("revoked", (Object)this.revoked).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String toJsonString() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            Report report = this;
            synchronized (report) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.toJsonString = Objects.requireNonNull(ReportSdo.super.toJsonString(), "toJsonString");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.toJsonString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String getSpecVersion() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            Report report = this;
            synchronized (report) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.specVersion = Objects.requireNonNull(ReportSdo.super.getSpecVersion(), "specVersion");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.specVersion;
    }

    private static Report validate(Report instance) {
        instance.checkHydrationValidation();
        return instance;
    }

    public static Report copyOf(ReportSdo instance) {
        if (instance instanceof Report) {
            return (Report)instance;
        }
        return Report.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return Report.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonTypeName(value="report")
    @JsonPropertyOrder(value={"type", "id", "created_by_ref", "created", "modified", "revoked", "labels", "external_references", "object_marking_refs", "granular_markings", "name", "description", "published", "object_refs"})
    @Generated(from="ReportSdo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_LABELS = 1L;
        private static final long OPT_BIT_OBJECT_REFS = 2L;
        private static final long OPT_BIT_RELATIONSHIPS = 4L;
        private static final long OPT_BIT_HYDRATED = 8L;
        private static final long OPT_BIT_EXTERNAL_REFERENCES = 16L;
        private static final long OPT_BIT_OBJECT_MARKING_REFS = 32L;
        private static final long OPT_BIT_GRANULAR_MARKINGS = 64L;
        private long optBits;
        private ImmutableSet.Builder<String> labels = ImmutableSet.builder();
        @Nullable
        private String name;
        @Nullable
        private String description;
        @Nullable
        private StixInstant published;
        private ImmutableSet.Builder<BundleableObject> objectRefs = ImmutableSet.builder();
        private ImmutableSet.Builder<RelationshipSro> relationships = ImmutableSet.builder();
        private boolean hydrated;
        @Nullable
        private String type;
        @Nullable
        private String id;
        @Nullable
        private IdentitySdo createdByRef;
        @Nullable
        private StixInstant created;
        @Nullable
        private String lang;
        private ImmutableSet.Builder<ExternalReferenceType> externalReferences = ImmutableSet.builder();
        private ImmutableSet.Builder<MarkingDefinitionDm> objectMarkingRefs = ImmutableSet.builder();
        private ImmutableSet.Builder<GranularMarkingDm> granularMarkings = ImmutableSet.builder();
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();
        @Nullable
        private StixInstant modified;
        @Nullable
        private StixBoolean revoked;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ReportSdo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(BundleableObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCommonProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixRevoked instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixLabels instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixModified instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(DomainObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof ReportSdo) {
                Optional<String> descriptionOptional;
                instance = (ReportSdo)object;
                String nameValue = instance.getName();
                if (nameValue != null) {
                    this.name(nameValue);
                }
                if ((descriptionOptional = instance.getDescription()).isPresent()) {
                    this.description(descriptionOptional);
                }
                this.addAllObjectRefs(instance.getObjectRefs());
                StixInstant publishedValue = instance.getPublished();
                if (publishedValue != null) {
                    this.published(publishedValue);
                }
                if ((bits & 2L) == 0L) {
                    this.addAllLabels(instance.getLabels());
                    bits |= 2L;
                }
            }
            if (object instanceof BundleableObject) {
                instance = (BundleableObject)object;
                if ((bits & 0x10L) == 0L) {
                    String idValue = instance.getId();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
                    bits |= 0x20L;
                }
                if ((bits & 1L) == 0L) {
                    String typeValue = instance.getType();
                    if (typeValue != null) {
                        this.type(typeValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.hydrated(instance.getHydrated());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.addAllGranularMarkings(instance.getGranularMarkings());
                    bits |= 8L;
                }
            }
            if (object instanceof StixCommonProperties) {
                Optional<String> langOptional;
                Optional<IdentitySdo> createdByRefOptional;
                instance = (StixCommonProperties)object;
                this.addAllExternalReferences(instance.getExternalReferences());
                if ((bits & 4L) == 0L) {
                    this.hydrated(instance.getHydrated());
                    bits |= 4L;
                }
                this.created(instance.getCreated());
                if ((bits & 8L) == 0L) {
                    this.addAllGranularMarkings(instance.getGranularMarkings());
                    bits |= 8L;
                }
                if ((createdByRefOptional = instance.getCreatedByRef()).isPresent()) {
                    this.createdByRef(createdByRefOptional);
                }
                if ((bits & 0x10L) == 0L) {
                    String idValue = instance.getId();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
                    bits |= 0x20L;
                }
                if ((bits & 1L) == 0L) {
                    String typeValue = instance.getType();
                    if (typeValue != null) {
                        this.type(typeValue);
                    }
                    bits |= 1L;
                }
                if ((langOptional = instance.getLang()).isPresent()) {
                    this.lang(langOptional);
                }
            }
            if (object instanceof StixRevoked) {
                instance = (StixRevoked)object;
                this.revoked(instance.getRevoked());
            }
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
            if (object instanceof StixLabels) {
                instance = (StixLabels)object;
                if ((bits & 2L) == 0L) {
                    this.addAllLabels(instance.getLabels());
                    bits |= 2L;
                }
            }
            if (object instanceof StixModified) {
                instance = (StixModified)object;
                this.modified(instance.getModified());
            }
            if (object instanceof DomainObject) {
                instance = (DomainObject)object;
                this.addAllRelationships(instance.getRelationships());
            }
        }

        @CanIgnoreReturnValue
        public final Builder addLabel(@Nullable String element) {
            this.labels.add((Object)element);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLabels(String ... elements) {
            this.labels.add((Object[])elements);
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="labels")
        @JsonPropertyDescription(value="This field is an Open Vocabulary that specifies the primary subject of this report. The suggested values for this field are in report-label-ov.")
        @CanIgnoreReturnValue
        public final Builder labels(Iterable<String> elements) {
            this.labels = ImmutableSet.builder();
            return this.addAllLabels(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllLabels(Iterable<String> elements) {
            this.labels.addAll(elements);
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="name")
        @JsonPropertyDescription(value="A description that provides more details and context about Report.")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="description")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="A description that provides more details and context about Report.")
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @JsonProperty(value="published")
        @JsonPropertyDescription(value="The date that this report object was officially published by the creator of this report.")
        @CanIgnoreReturnValue
        public final Builder published(StixInstant published) {
            this.published = published;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjectRef(@Nullable BundleableObject element) {
            this.objectRefs.add((Object)element);
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjectRefs(BundleableObject ... elements) {
            this.objectRefs.add((Object[])elements);
            this.optBits |= 2L;
            return this;
        }

        @JsonProperty(value="object_refs")
        @JsonPropertyDescription(value="Specifies the STIX Objects that are referred to by this Report.")
        @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
        @JsonIdentityReference(alwaysAsId=true)
        @JsonDeserialize(converter=BundleableObjectSetConverter.class)
        @CanIgnoreReturnValue
        public final Builder objectRefs(Iterable<? extends BundleableObject> elements) {
            this.objectRefs = ImmutableSet.builder();
            return this.addAllObjectRefs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllObjectRefs(Iterable<? extends BundleableObject> elements) {
            this.objectRefs.addAll(elements);
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRelationship(@Nullable RelationshipSro element) {
            this.relationships.add((Object)element);
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRelationships(RelationshipSro ... elements) {
            this.relationships.add((Object[])elements);
            this.optBits |= 4L;
            return this;
        }

        @JsonProperty(value="relationships")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder relationships(Iterable<? extends RelationshipSro> elements) {
            this.relationships = ImmutableSet.builder();
            return this.addAllRelationships(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRelationships(Iterable<? extends RelationshipSro> elements) {
            this.relationships.addAll(elements);
            this.optBits |= 4L;
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        @CanIgnoreReturnValue
        public final Builder hydrated(boolean hydrated) {
            this.hydrated = hydrated;
            this.optBits |= 8L;
            return this;
        }

        @JsonProperty(value="type")
        @JsonPropertyDescription(value="The type property identifies the type of STIX Object (SDO, Relationship Object, etc). The value of the type field MUST be one of the types defined by a STIX Object (e.g., indicator).")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="id")
        @JsonPropertyDescription(value="Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder createdByRef(IdentitySdo createdByRef) {
            this.createdByRef = Objects.requireNonNull(createdByRef, "createdByRef");
            return this;
        }

        @JsonProperty(value="created_by_ref")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
        @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
        @JsonIdentityReference(alwaysAsId=true)
        @JsonDeserialize(converter=DomainObjectOptionalConverter.class)
        @CanIgnoreReturnValue
        public final Builder createdByRef(Optional<? extends IdentitySdo> createdByRef) {
            this.createdByRef = createdByRef.orElse(null);
            return this;
        }

        @JsonProperty(value="created")
        @JsonPropertyDescription(value="The created property represents the time at which the first version of this object was created. The timstamp value MUST be precise to the nearest millisecond.")
        @CanIgnoreReturnValue
        public final Builder created(StixInstant created) {
            this.created = Objects.requireNonNull(created, "created");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lang(String lang) {
            this.lang = Objects.requireNonNull(lang, "lang");
            return this;
        }

        @JsonProperty(value="lang")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="Identifies the language of the text content in this object using ISO 639-2 language codes.")
        @CanIgnoreReturnValue
        public final Builder lang(Optional<String> lang) {
            this.lang = lang.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExternalReference(@Nullable ExternalReferenceType element) {
            this.externalReferences.add((Object)element);
            this.optBits |= 0x10L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExternalReferences(ExternalReferenceType ... elements) {
            this.externalReferences.add((Object[])elements);
            this.optBits |= 0x10L;
            return this;
        }

        @JsonProperty(value="external_references")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="A list of external references which refers to non-STIX information.")
        @CanIgnoreReturnValue
        public final Builder externalReferences(Iterable<? extends ExternalReferenceType> elements) {
            this.externalReferences = ImmutableSet.builder();
            return this.addAllExternalReferences(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllExternalReferences(Iterable<? extends ExternalReferenceType> elements) {
            this.externalReferences.addAll(elements);
            this.optBits |= 0x10L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjectMarkingRef(@Nullable MarkingDefinitionDm element) {
            this.objectMarkingRefs.add((Object)element);
            this.optBits |= 0x20L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjectMarkingRefs(MarkingDefinitionDm ... elements) {
            this.objectMarkingRefs.add((Object[])elements);
            this.optBits |= 0x20L;
            return this;
        }

        @JsonProperty(value="object_marking_refs")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The list of marking-definition objects to be applied to this object.")
        @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
        @JsonIdentityReference(alwaysAsId=true)
        @JsonDeserialize(converter=MarkingDefinitionSetConverter.class)
        @CanIgnoreReturnValue
        public final Builder objectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
            this.objectMarkingRefs = ImmutableSet.builder();
            return this.addAllObjectMarkingRefs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
            this.objectMarkingRefs.addAll(elements);
            this.optBits |= 0x20L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGranularMarking(@Nullable GranularMarkingDm element) {
            this.granularMarkings.add((Object)element);
            this.optBits |= 0x40L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGranularMarkings(GranularMarkingDm ... elements) {
            this.granularMarkings.add((Object[])elements);
            this.optBits |= 0x40L;
            return this;
        }

        @JsonProperty(value="granular_markings")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The set of granular markings that apply to this object.")
        @CanIgnoreReturnValue
        public final Builder granularMarkings(Iterable<? extends GranularMarkingDm> elements) {
            this.granularMarkings = ImmutableSet.builder();
            return this.addAllGranularMarkings(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
            this.granularMarkings.addAll(elements);
            this.optBits |= 0x40L;
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        @JsonProperty(value="modified")
        @JsonPropertyDescription(value="The modified property represents the time that this particular version of the object was created. The timstamp value MUST be precise to the nearest millisecond.")
        @CanIgnoreReturnValue
        public final Builder modified(StixInstant modified) {
            this.modified = Objects.requireNonNull(modified, "modified");
            return this;
        }

        @JsonProperty(value="revoked")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The revoked property indicates whether the object has been revoked.")
        @CanIgnoreReturnValue
        public final Builder revoked(StixBoolean revoked) {
            this.revoked = Objects.requireNonNull(revoked, "revoked");
            return this;
        }

        public Report build() {
            return Report.validate(new Report(this));
        }

        private boolean labelsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean objectRefsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean relationshipsIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean hydratedIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean externalReferencesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean objectMarkingRefsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean granularMarkingsIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }
    }

    @Generated(from="ReportSdo", generator="Immutables")
    private final class InitShim {
        private byte labelsBuildStage = 0;
        private ImmutableSet<String> labels;
        private byte objectRefsBuildStage = 0;
        private ImmutableSet<BundleableObject> objectRefs;
        private byte relationshipsBuildStage = 0;
        private ImmutableSet<RelationshipSro> relationships;
        private byte hydratedBuildStage = 0;
        private boolean hydrated;
        private byte createdBuildStage = 0;
        private StixInstant created;
        private byte externalReferencesBuildStage = 0;
        private ImmutableSet<ExternalReferenceType> externalReferences;
        private byte objectMarkingRefsBuildStage = 0;
        private ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;
        private byte granularMarkingsBuildStage = 0;
        private ImmutableSet<GranularMarkingDm> granularMarkings;
        private byte modifiedBuildStage = 0;
        private StixInstant modified;
        private byte revokedBuildStage = 0;
        private StixBoolean revoked;

        private InitShim() {
        }

        ImmutableSet<String> getLabels() {
            if (this.labelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.labelsBuildStage == 0) {
                this.labelsBuildStage = (byte)-1;
                this.labels = ImmutableSet.copyOf((Collection)Report.this.getLabelsInitialize());
                this.labelsBuildStage = 1;
            }
            return this.labels;
        }

        void labels(ImmutableSet<String> labels) {
            this.labels = labels;
            this.labelsBuildStage = 1;
        }

        ImmutableSet<BundleableObject> getObjectRefs() {
            if (this.objectRefsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.objectRefsBuildStage == 0) {
                this.objectRefsBuildStage = (byte)-1;
                this.objectRefs = ImmutableSet.copyOf((Collection)Report.this.getObjectRefsInitialize());
                this.objectRefsBuildStage = 1;
            }
            return this.objectRefs;
        }

        void objectRefs(ImmutableSet<BundleableObject> objectRefs) {
            this.objectRefs = objectRefs;
            this.objectRefsBuildStage = 1;
        }

        ImmutableSet<RelationshipSro> getRelationships() {
            if (this.relationshipsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipsBuildStage == 0) {
                this.relationshipsBuildStage = (byte)-1;
                this.relationships = ImmutableSet.copyOf((Collection)Report.this.getRelationshipsInitialize());
                this.relationshipsBuildStage = 1;
            }
            return this.relationships;
        }

        void relationships(ImmutableSet<RelationshipSro> relationships) {
            this.relationships = relationships;
            this.relationshipsBuildStage = 1;
        }

        boolean getHydrated() {
            if (this.hydratedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hydratedBuildStage == 0) {
                this.hydratedBuildStage = (byte)-1;
                this.hydrated = Report.this.getHydratedInitialize();
                this.hydratedBuildStage = 1;
            }
            return this.hydrated;
        }

        void hydrated(boolean hydrated) {
            this.hydrated = hydrated;
            this.hydratedBuildStage = 1;
        }

        StixInstant getCreated() {
            if (this.createdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.createdBuildStage == 0) {
                this.createdBuildStage = (byte)-1;
                this.created = Objects.requireNonNull(Report.this.getCreatedInitialize(), "created");
                this.createdBuildStage = 1;
            }
            return this.created;
        }

        void created(StixInstant created) {
            this.created = created;
            this.createdBuildStage = 1;
        }

        ImmutableSet<ExternalReferenceType> getExternalReferences() {
            if (this.externalReferencesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.externalReferencesBuildStage == 0) {
                this.externalReferencesBuildStage = (byte)-1;
                this.externalReferences = ImmutableSet.copyOf((Collection)Report.this.getExternalReferencesInitialize());
                this.externalReferencesBuildStage = 1;
            }
            return this.externalReferences;
        }

        void externalReferences(ImmutableSet<ExternalReferenceType> externalReferences) {
            this.externalReferences = externalReferences;
            this.externalReferencesBuildStage = 1;
        }

        ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
            if (this.objectMarkingRefsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.objectMarkingRefsBuildStage == 0) {
                this.objectMarkingRefsBuildStage = (byte)-1;
                this.objectMarkingRefs = ImmutableSet.copyOf((Collection)Report.this.getObjectMarkingRefsInitialize());
                this.objectMarkingRefsBuildStage = 1;
            }
            return this.objectMarkingRefs;
        }

        void objectMarkingRefs(ImmutableSet<MarkingDefinitionDm> objectMarkingRefs) {
            this.objectMarkingRefs = objectMarkingRefs;
            this.objectMarkingRefsBuildStage = 1;
        }

        ImmutableSet<GranularMarkingDm> getGranularMarkings() {
            if (this.granularMarkingsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.granularMarkingsBuildStage == 0) {
                this.granularMarkingsBuildStage = (byte)-1;
                this.granularMarkings = ImmutableSet.copyOf((Collection)Report.this.getGranularMarkingsInitialize());
                this.granularMarkingsBuildStage = 1;
            }
            return this.granularMarkings;
        }

        void granularMarkings(ImmutableSet<GranularMarkingDm> granularMarkings) {
            this.granularMarkings = granularMarkings;
            this.granularMarkingsBuildStage = 1;
        }

        StixInstant getModified() {
            if (this.modifiedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.modifiedBuildStage == 0) {
                this.modifiedBuildStage = (byte)-1;
                this.modified = Objects.requireNonNull(Report.this.getModifiedInitialize(), "modified");
                this.modifiedBuildStage = 1;
            }
            return this.modified;
        }

        void modified(StixInstant modified) {
            this.modified = modified;
            this.modifiedBuildStage = 1;
        }

        StixBoolean getRevoked() {
            if (this.revokedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.revokedBuildStage == 0) {
                this.revokedBuildStage = (byte)-1;
                this.revoked = Objects.requireNonNull(Report.this.getRevokedInitialize(), "revoked");
                this.revokedBuildStage = 1;
            }
            return this.revoked;
        }

        void revoked(StixBoolean revoked) {
            this.revoked = revoked;
            this.revokedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.labelsBuildStage == -1) {
                attributes.add("labels");
            }
            if (this.objectRefsBuildStage == -1) {
                attributes.add("objectRefs");
            }
            if (this.relationshipsBuildStage == -1) {
                attributes.add("relationships");
            }
            if (this.hydratedBuildStage == -1) {
                attributes.add("hydrated");
            }
            if (this.createdBuildStage == -1) {
                attributes.add("created");
            }
            if (this.externalReferencesBuildStage == -1) {
                attributes.add("externalReferences");
            }
            if (this.objectMarkingRefsBuildStage == -1) {
                attributes.add("objectMarkingRefs");
            }
            if (this.granularMarkingsBuildStage == -1) {
                attributes.add("granularMarkings");
            }
            if (this.modifiedBuildStage == -1) {
                attributes.add("modified");
            }
            if (this.revokedBuildStage == -1) {
                attributes.add("revoked");
            }
            return "Cannot build Report, attribute initializers form cycle " + attributes;
        }
    }
}

