/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.sdo.objects;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.json.converters.dehydrated.BundleableObjectSetConverter;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.DomainObject;
import security.whisper.javastix.sdo.objects.Report;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.constraints.vocab.Vocab;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;
import security.whisper.javastix.vocabulary.vocabularies.ReportLabels;

@JsonTypeName(value="report")
@DefaultTypeValue(value="report", groups={DefaultValuesProcessor.class})
@JsonSerialize(as=Report.class)
@JsonDeserialize(builder=Report.Builder.class)
@JsonPropertyOrder(value={"type", "id", "created_by_ref", "created", "modified", "revoked", "labels", "external_references", "object_marking_refs", "granular_markings", "name", "description", "published", "object_refs"})
@Redactable
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Sdo"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface ReportSdo
extends DomainObject {
    @Override
    @NotNull
    @JsonPropertyDescription(value="This field is an Open Vocabulary that specifies the primary subject of this report. The suggested values for this field are in report-label-ov.")
    @Redactable(useMask=true)
    @Size(min=1)
    @Value.Default
    default public @NotNull @Size(min=1) Set<@Vocab(value=ReportLabels.class) String> getLabels() {
        return Collections.emptySet();
    }

    @NotBlank
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="A description that provides more details and context about Report.")
    @Redactable(useMask=true)
    public String getName();

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A description that provides more details and context about Report.")
    @Redactable
    public Optional<String> getDescription();

    @NotNull
    @JsonProperty(value="published")
    @JsonPropertyDescription(value="The date that this report object was officially published by the creator of this report.")
    @Redactable(useMask=true)
    public StixInstant getPublished();

    @NotNull
    @Size(min=1, message="Must have at least one Report object reference")
    @JsonProperty(value="object_refs")
    @JsonPropertyDescription(value="Specifies the STIX Objects that are referred to by this Report.")
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    @JsonDeserialize(converter=BundleableObjectSetConverter.class)
    @Redactable(useMask=true)
    @Value.Default
    default public @NotNull @Size(min=1, message="Must have at least one Report object reference") Set<BundleableObject> getObjectRefs() {
        return Collections.emptySet();
    }
}

