/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.sdo.objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.DomainObject;
import security.whisper.javastix.sdo.objects.ThreatActor;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.constraints.vocab.Vocab;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;
import security.whisper.javastix.vocabulary.vocabularies.AttackMotivations;
import security.whisper.javastix.vocabulary.vocabularies.AttackResourceLevels;
import security.whisper.javastix.vocabulary.vocabularies.ThreatActorLabels;
import security.whisper.javastix.vocabulary.vocabularies.ThreatActorRoles;
import security.whisper.javastix.vocabulary.vocabularies.ThreatActorSophistication;

@JsonTypeName(value="threat-actor")
@DefaultTypeValue(value="threat-actor", groups={DefaultValuesProcessor.class})
@JsonSerialize(as=ThreatActor.class)
@JsonDeserialize(builder=ThreatActor.Builder.class)
@JsonPropertyOrder(value={"type", "id", "created_by_ref", "created", "modified", "revoked", "labels", "external_references", "object_marking_refs", "granular_markings", "uses", "name", "description", "aliases", "roles", "goals", "sophistication", "resource_level", "primary_motivation", "secondary_motivation", "personal_motivations"})
@Redactable
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Sdo"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true, depluralizeDictionary={"alias:aliases"})
public interface ThreatActorSdo
extends DomainObject {
    @Override
    @NotNull
    @Size(min=1, message="Must have at least one value from threat-actor-label-ov")
    @Vocab(value=ThreatActorLabels.class)
    @JsonPropertyDescription(value="This field specifies the type of threat actor. Open Vocab - threat-actor-label-ov")
    @Redactable(useMask=true)
    @Value.Default
    default public @NotNull @Size(min=1, message="Must have at least one value from threat-actor-label-ov") @Vocab(value=ThreatActorLabels.class) Set<@Size(min=1) String> getLabels() {
        return Collections.emptySet();
    }

    @NotBlank
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="A name used to identify this Threat Actor or Threat Actor group.")
    @Redactable(useMask=true)
    public String getName();

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A description that provides more details and context about the Threat Actor.")
    @Redactable
    public Optional<String> getDescription();

    @NotNull
    @JsonProperty(value="aliases")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A list of other names that this Threat Actor is believed to use.")
    @Redactable
    @Value.Default
    default public Set<String> getAliases() {
        return Collections.emptySet();
    }

    @NotNull
    @Vocab(value=ThreatActorRoles.class)
    @JsonProperty(value="roles")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="This is a list of roles the Threat Actor plays. Open Vocab - threat-actor-role-ov")
    @Redactable
    @Value.Default
    default public Set<String> getRoles() {
        return Collections.emptySet();
    }

    @NotNull
    @JsonProperty(value="goals")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The high level goals of this Threat Actor, namely, what are they trying to do.")
    @Redactable
    @Value.Default
    default public @NotNull Set<@Size(min=1) String> getGoals() {
        return Collections.emptySet();
    }

    @NotNull
    @JsonProperty(value="sophistication")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The skill, specific knowledge, special training, or expertise a Threat Actor must have to perform the attack. Open Vocab - threat-actor-sophistication-ov")
    @Redactable
    public @NotNull Optional<@Vocab(value=ThreatActorSophistication.class) String> getSophistication();

    @JsonProperty(value="resource_level")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="This defines the organizational level at which this Threat Actor typically works. Open Vocab - attack-resource-level-ov")
    @Redactable
    public Optional<@Vocab(value=AttackResourceLevels.class) String> getResourceLevel();

    @JsonProperty(value="primary_motivation")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The primary reason, motivation, or purpose behind this Threat Actor. Open Vocab - attack-motivation-ov")
    @Redactable
    public Optional<@Vocab(value=AttackMotivations.class) String> getPrimaryMotivation();

    @NotNull
    @Vocab(value=AttackMotivations.class)
    @JsonProperty(value="secondary_motivations")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The secondary reasons, motivations, or purposes behind this Threat Actor. Open Vocab - attack-motivation-ov")
    @Redactable
    @Value.Default
    default public Set<String> getSecondaryMotivations() {
        return Collections.emptySet();
    }

    @NotNull
    @Vocab(value=AttackMotivations.class)
    @JsonProperty(value="personal_motivations")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The personal reasons, motivations, or purposes of the Threat Actor regardless of organizational goals. Open Vocab - attack-motivation-ov")
    @Redactable
    @Value.Default
    default public Set<String> getPersonalMotivations() {
        return Collections.emptySet();
    }
}

