/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.sdo.objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.DomainObject;
import security.whisper.javastix.sdo.objects.Tool;
import security.whisper.javastix.sdo.types.KillChainPhaseType;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.constraints.vocab.Vocab;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;
import security.whisper.javastix.vocabulary.vocabularies.ToolLabels;

@JsonTypeName(value="tool")
@DefaultTypeValue(value="tool", groups={DefaultValuesProcessor.class})
@JsonSerialize(as=Tool.class)
@JsonDeserialize(builder=Tool.Builder.class)
@JsonPropertyOrder(value={"type", "id", "created_by_ref", "created", "modified", "revoked", "labels", "external_references", "object_marking_refs", "granular_markings", "name", "description", "kill_chain_phases", "tool_version"})
@Redactable
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Sdo"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface ToolSdo
extends DomainObject {
    @Override
    @NotNull
    @Vocab(value=ToolLabels.class)
    @JsonPropertyDescription(value="The kind(s) of tool(s) being described. Open Vocab - tool-label-ov")
    @Redactable(useMask=true)
    @Value.Default
    default public @NotNull @Vocab(value=ToolLabels.class) Set<@Length(min=1) String> getLabels() {
        return Collections.emptySet();
    }

    @NotBlank
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="The name used to identify the Tool.")
    @Redactable(useMask=true)
    public String getName();

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Provides more context and details about the Tool object.")
    @Redactable
    public Optional<String> getDescription();

    @NotNull
    @JsonProperty(value="kill_chain_phases")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The list of kill chain phases for which this Tool instance can be used.")
    @Redactable
    @Value.Default
    default public Set<KillChainPhaseType> getKillChainPhases() {
        return Collections.emptySet();
    }

    @JsonProperty(value="tool_version")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The version identifier associated with the tool.")
    @Redactable
    public Optional<String> getToolVersion();
}

