/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.sdo.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.sdo.types.ExternalReferenceType;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ExternalReferenceType", generator="Immutables")
@Immutable
public final class ExternalReference
implements ExternalReferenceType {
    private final String sourceName;
    @Nullable
    private final String description;
    @Nullable
    private final String url;
    private final ImmutableMap<String, String> hashes;
    @Nullable
    private final String externalId;
    private final ImmutableMap<String, Object> customProperties;
    private static final long serialVersionUID = 1L;

    private ExternalReference(String sourceName, @Nullable String description, @Nullable String url, ImmutableMap<String, String> hashes, @Nullable String externalId, ImmutableMap<String, Object> customProperties) {
        this.sourceName = sourceName;
        this.description = description;
        this.url = url;
        this.hashes = hashes;
        this.externalId = externalId;
        this.customProperties = customProperties;
    }

    @Override
    @JsonProperty(value="source_name")
    @JsonPropertyDescription(value="The source within which the external-reference is defined (system, registry, organization, etc.)")
    public String getSourceName() {
        return this.sourceName;
    }

    @Override
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A human readable description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Matches the elements of a URL using a regular expression. Uses Diego Perini's regex from https://gist.github.com/dperini/729294.")
    public Optional<String> getUrl() {
        return Optional.ofNullable(this.url);
    }

    @JsonProperty(value="hashes")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Specifies a dictionary of hashes for the file.")
    public ImmutableMap<String, String> getHashes() {
        return this.hashes;
    }

    @Override
    @JsonProperty(value="external_id")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="An identifier for the external reference content")
    public Optional<String> getExternalId() {
        return Optional.ofNullable(this.externalId);
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public final ExternalReference withSourceName(String value) {
        if (Objects.equals(this.sourceName, value)) {
            return this;
        }
        return ExternalReference.validate(new ExternalReference(value, this.description, this.url, this.hashes, this.externalId, this.customProperties));
    }

    public final ExternalReference withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return ExternalReference.validate(new ExternalReference(this.sourceName, newValue, this.url, this.hashes, this.externalId, this.customProperties));
    }

    public final ExternalReference withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return ExternalReference.validate(new ExternalReference(this.sourceName, value, this.url, this.hashes, this.externalId, this.customProperties));
    }

    public final ExternalReference withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (Objects.equals(this.url, newValue)) {
            return this;
        }
        return ExternalReference.validate(new ExternalReference(this.sourceName, this.description, newValue, this.hashes, this.externalId, this.customProperties));
    }

    public final ExternalReference withUrl(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.url, value)) {
            return this;
        }
        return ExternalReference.validate(new ExternalReference(this.sourceName, this.description, value, this.hashes, this.externalId, this.customProperties));
    }

    public final ExternalReference withHashes(Map<String, ? extends String> entries) {
        if (this.hashes == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return ExternalReference.validate(new ExternalReference(this.sourceName, this.description, this.url, (ImmutableMap<String, String>)newValue, this.externalId, this.customProperties));
    }

    public final ExternalReference withExternalId(String value) {
        String newValue = Objects.requireNonNull(value, "externalId");
        if (Objects.equals(this.externalId, newValue)) {
            return this;
        }
        return ExternalReference.validate(new ExternalReference(this.sourceName, this.description, this.url, this.hashes, newValue, this.customProperties));
    }

    public final ExternalReference withExternalId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.externalId, value)) {
            return this;
        }
        return ExternalReference.validate(new ExternalReference(this.sourceName, this.description, this.url, this.hashes, value, this.customProperties));
    }

    public final ExternalReference withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return ExternalReference.validate(new ExternalReference(this.sourceName, this.description, this.url, this.hashes, this.externalId, (ImmutableMap<String, Object>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ExternalReference && this.equalTo((ExternalReference)another);
    }

    private boolean equalTo(ExternalReference another) {
        return Objects.equals(this.sourceName, another.sourceName) && Objects.equals(this.description, another.description) && Objects.equals(this.url, another.url) && this.hashes.equals(another.hashes) && Objects.equals(this.externalId, another.externalId) && this.customProperties.equals(another.customProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.sourceName);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + this.hashes.hashCode();
        h += (h << 5) + Objects.hashCode(this.externalId);
        h += (h << 5) + this.customProperties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ExternalReference").omitNullValues().add("sourceName", (Object)this.sourceName).add("description", (Object)this.description).add("url", (Object)this.url).add("hashes", this.hashes).add("externalId", (Object)this.externalId).add("customProperties", this.customProperties).toString();
    }

    private static ExternalReference validate(ExternalReference instance) {
        instance.validateEntity();
        return instance;
    }

    public static ExternalReference copyOf(ExternalReferenceType instance) {
        if (instance instanceof ExternalReference) {
            return (ExternalReference)instance;
        }
        return ExternalReference.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return ExternalReference.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonPropertyOrder(value={"source_name", "description", "url", "hashes", "external_id"})
    @Generated(from="ExternalReferenceType", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String sourceName;
        @Nullable
        private String description;
        @Nullable
        private String url;
        private ImmutableMap.Builder<String, String> hashes = ImmutableMap.builder();
        @Nullable
        private String externalId;
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ExternalReferenceType instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            StixCustomProperties instance;
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
            if (object instanceof ExternalReferenceType) {
                Optional<String> urlOptional;
                String sourceNameValue;
                Optional<String> externalIdOptional;
                instance = (ExternalReferenceType)object;
                this.putAllHashes(instance.getHashes());
                Optional<String> descriptionOptional = instance.getDescription();
                if (descriptionOptional.isPresent()) {
                    this.description(descriptionOptional);
                }
                if ((externalIdOptional = instance.getExternalId()).isPresent()) {
                    this.externalId(externalIdOptional);
                }
                if ((sourceNameValue = instance.getSourceName()) != null) {
                    this.sourceName(sourceNameValue);
                }
                if ((urlOptional = instance.getUrl()).isPresent()) {
                    this.url(urlOptional);
                }
            }
        }

        @JsonProperty(value="source_name")
        @JsonPropertyDescription(value="The source within which the external-reference is defined (system, registry, organization, etc.)")
        @CanIgnoreReturnValue
        public final Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="description")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="A human readable description")
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            return this;
        }

        @JsonProperty(value="url")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="Matches the elements of a URL using a regular expression. Uses Diego Perini's regex from https://gist.github.com/dperini/729294.")
        @CanIgnoreReturnValue
        public final Builder url(Optional<String> url) {
            this.url = url.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putHash(String key, String value) {
            this.hashes.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putHash(Map.Entry<String, ? extends String> entry) {
            this.hashes.put(entry);
            return this;
        }

        @JsonProperty(value="hashes")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="Specifies a dictionary of hashes for the file.")
        @CanIgnoreReturnValue
        public final Builder hashes(Map<String, ? extends String> entries) {
            this.hashes = ImmutableMap.builder();
            return this.putAllHashes(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllHashes(Map<String, ? extends String> entries) {
            this.hashes.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder externalId(String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId");
            return this;
        }

        @JsonProperty(value="external_id")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="An identifier for the external reference content")
        @CanIgnoreReturnValue
        public final Builder externalId(Optional<String> externalId) {
            this.externalId = externalId.orElse(null);
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        public ExternalReference build() {
            return ExternalReference.validate(new ExternalReference(this.sourceName, this.description, this.url, this.hashes.build(), this.externalId, this.customProperties.build()));
        }
    }
}

