/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.sdo.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import javax.validation.constraints.NotBlank;
import org.hibernate.validator.constraints.Length;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.sdo.types.ExternalReference;
import security.whisper.javastix.validation.GenericValidation;
import security.whisper.javastix.validation.constraints.hashingvocab.HashingVocab;
import security.whisper.javastix.vocabulary.vocabularies.HashingAlgorithms;

@JsonSerialize(as=ExternalReference.class)
@JsonDeserialize(builder=ExternalReference.Builder.class)
@JsonPropertyOrder(value={"source_name", "description", "url", "hashes", "external_id"})
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Type"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, depluralize=true, depluralizeDictionary={"hash:hashes"})
public interface ExternalReferenceType
extends GenericValidation,
StixCustomProperties,
Serializable {
    @NotBlank
    @JsonProperty(value="source_name")
    @JsonPropertyDescription(value="The source within which the external-reference is defined (system, registry, organization, etc.)")
    public String getSourceName();

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A human readable description")
    public Optional<String> getDescription();

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Matches the elements of a URL using a regular expression. Uses Diego Perini's regex from https://gist.github.com/dperini/729294.")
    public Optional<String> getUrl();

    @JsonProperty(value="hashes")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Specifies a dictionary of hashes for the file.")
    public Map<@Length(min=3, max=256) @HashingVocab(value=HashingAlgorithms.class) String, String> getHashes();

    @JsonProperty(value="external_id")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="An identifier for the external reference content")
    public Optional<String> getExternalId();
}

