/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.sdo.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.sdo.types.KillChainPhaseType;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="KillChainPhaseType", generator="Immutables")
@Immutable
public final class KillChainPhase
implements KillChainPhaseType {
    private final String killChainName;
    private final String phaseName;
    private final ImmutableMap<String, Object> customProperties;
    private static final long serialVersionUID = 1L;

    private KillChainPhase(String killChainName, String phaseName, ImmutableMap<String, Object> customProperties) {
        this.killChainName = killChainName;
        this.phaseName = phaseName;
        this.customProperties = customProperties;
    }

    @Override
    @JsonProperty(value="kill_chain_name")
    @JsonPropertyDescription(value="The name of the kill chain.")
    public String killChainName() {
        return this.killChainName;
    }

    @Override
    @JsonProperty(value="phase_name")
    @JsonPropertyDescription(value="The name of the phase in the kill chain.")
    public String phaseName() {
        return this.phaseName;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public final KillChainPhase withKillChainName(String value) {
        if (Objects.equals(this.killChainName, value)) {
            return this;
        }
        return KillChainPhase.validate(new KillChainPhase(value, this.phaseName, this.customProperties));
    }

    public final KillChainPhase withPhaseName(String value) {
        if (Objects.equals(this.phaseName, value)) {
            return this;
        }
        return KillChainPhase.validate(new KillChainPhase(this.killChainName, value, this.customProperties));
    }

    public final KillChainPhase withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return KillChainPhase.validate(new KillChainPhase(this.killChainName, this.phaseName, (ImmutableMap<String, Object>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof KillChainPhase && this.equalTo((KillChainPhase)another);
    }

    private boolean equalTo(KillChainPhase another) {
        return Objects.equals(this.killChainName, another.killChainName) && Objects.equals(this.phaseName, another.phaseName) && this.customProperties.equals(another.customProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.killChainName);
        h += (h << 5) + Objects.hashCode(this.phaseName);
        h += (h << 5) + this.customProperties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"KillChainPhase").omitNullValues().add("killChainName", (Object)this.killChainName).add("phaseName", (Object)this.phaseName).add("customProperties", this.customProperties).toString();
    }

    private static KillChainPhase validate(KillChainPhase instance) {
        instance.validateEntity();
        return instance;
    }

    public static KillChainPhase copyOf(KillChainPhaseType instance) {
        if (instance instanceof KillChainPhase) {
            return (KillChainPhase)instance;
        }
        return KillChainPhase.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return KillChainPhase.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonPropertyOrder(value={"kill_chain_name", "phase_name"})
    @Generated(from="KillChainPhaseType", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String killChainName;
        @Nullable
        private String phaseName;
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(KillChainPhaseType instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            StixCustomProperties instance;
            if (object instanceof KillChainPhaseType) {
                String phaseNameValue;
                instance = (KillChainPhaseType)object;
                String killChainNameValue = instance.killChainName();
                if (killChainNameValue != null) {
                    this.killChainName(killChainNameValue);
                }
                if ((phaseNameValue = instance.phaseName()) != null) {
                    this.phaseName(phaseNameValue);
                }
            }
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
        }

        @JsonProperty(value="kill_chain_name")
        @JsonPropertyDescription(value="The name of the kill chain.")
        @CanIgnoreReturnValue
        public final Builder killChainName(String killChainName) {
            this.killChainName = killChainName;
            return this;
        }

        @JsonProperty(value="phase_name")
        @JsonPropertyDescription(value="The name of the phase in the kill chain.")
        @CanIgnoreReturnValue
        public final Builder phaseName(String phaseName) {
            this.phaseName = phaseName;
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        public KillChainPhase build() {
            return KillChainPhase.validate(new KillChainPhase(this.killChainName, this.phaseName, this.customProperties.build()));
        }
    }
}

