/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.sdo.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.sdo.types.KillChainPhase;
import security.whisper.javastix.validation.GenericValidation;

@JsonSerialize(as=KillChainPhase.class)
@JsonDeserialize(builder=KillChainPhase.Builder.class)
@JsonPropertyOrder(value={"kill_chain_name", "phase_name"})
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Type"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, depluralize=true)
public interface KillChainPhaseType
extends GenericValidation,
StixCustomProperties,
Serializable {
    @NotBlank
    @JsonProperty(value="kill_chain_name")
    @JsonPropertyDescription(value="The name of the kill chain.")
    public String killChainName();

    @NotBlank
    @JsonProperty(value="phase_name")
    @JsonPropertyDescription(value="The name of the phase in the kill chain.")
    public String phaseName();

    public static enum LockheedMartinKillChain {
        RECONNAISSANCE("reconnaissance"),
        WEAPONIZATION("weaponization"),
        DELIVERY("delivery"),
        EXPLOITATION("exploitation"),
        INSTALLATION("installation"),
        COMMAND_AND_CONTROL("command-and-control"),
        ACTIONS_ON_OBJECTIVE("actions-on-objective");

        public static final String killChainName = "lockheed-martin-cyber-kill-chain";
        final String phase;

        private LockheedMartinKillChain(String val) {
            this.phase = val;
        }

        public String toString() {
            return this.phase;
        }

        @JsonValue
        public String getPhase() {
            return this.phase;
        }
    }
}

