/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.sro.objects;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Optional;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.json.converters.dehydrated.DomainObjectConverter;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.DomainObject;
import security.whisper.javastix.sdo.objects.AttackPatternSdo;
import security.whisper.javastix.sdo.objects.CampaignSdo;
import security.whisper.javastix.sdo.objects.CourseOfActionSdo;
import security.whisper.javastix.sdo.objects.IdentitySdo;
import security.whisper.javastix.sdo.objects.IndicatorSdo;
import security.whisper.javastix.sdo.objects.IntrusionSetSdo;
import security.whisper.javastix.sdo.objects.MalwareSdo;
import security.whisper.javastix.sdo.objects.ThreatActorSdo;
import security.whisper.javastix.sdo.objects.ToolSdo;
import security.whisper.javastix.sdo.objects.VulnerabilitySdo;
import security.whisper.javastix.sro.RelationshipObject;
import security.whisper.javastix.sro.objects.Relationship;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.constraints.relationship.RelationshipLimit;
import security.whisper.javastix.validation.constraints.relationship.RelationshipTypeLimit;
import security.whisper.javastix.validation.constraints.vocab.Vocab;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;
import security.whisper.javastix.vocabulary.vocabularies.RelationshipTypes;

@DefaultTypeValue(value="relationship", groups={DefaultValuesProcessor.class})
@JsonTypeName(value="relationship")
@JsonSerialize(as=Relationship.class)
@JsonDeserialize(builder=Relationship.Builder.class)
@JsonPropertyOrder(value={"type", "id", "created_by_ref", "created", "modified", "revoked", "labels", "external_references", "object_marking_refs", "granular_markings", "relationship_type", "description", "source_ref", "target_ref"})
@Redactable
@RelationshipTypeLimit.List(value={@RelationshipTypeLimit(source=AttackPatternSdo.class, relationshipTypes={"targets", "uses"}), @RelationshipTypeLimit(source=CampaignSdo.class, relationshipTypes={"attributed-to", "targets", "uses"}), @RelationshipTypeLimit(source=CourseOfActionSdo.class, relationshipTypes={"mitigates"}), @RelationshipTypeLimit(source=IdentitySdo.class, relationshipTypes={"targets", "attributed-to", "impersonates"}), @RelationshipTypeLimit(source=IndicatorSdo.class, relationshipTypes={"indicates"}), @RelationshipTypeLimit(source=IntrusionSetSdo.class, relationshipTypes={"attributed-to", "targets", "uses"}), @RelationshipTypeLimit(source=MalwareSdo.class, relationshipTypes={"targets", "uses", "variant-of"}), @RelationshipTypeLimit(source=ThreatActorSdo.class, relationshipTypes={"attributed-to", "impersonates", "targets", "uses"}), @RelationshipTypeLimit(source=ToolSdo.class, relationshipTypes={"targets"})})
@RelationshipLimit.List(value={@RelationshipLimit(source=DomainObject.class, relationshipType="derived-from", target={DomainObject.class}, classEquality=true), @RelationshipLimit(source=DomainObject.class, relationshipType="duplicate-of", target={DomainObject.class}, classEquality=true), @RelationshipLimit(source=DomainObject.class, relationshipType="related-to", target={DomainObject.class}), @RelationshipLimit(source=AttackPatternSdo.class, relationshipType="targets", target={IdentitySdo.class, VulnerabilitySdo.class}), @RelationshipLimit(source=AttackPatternSdo.class, relationshipType="uses", target={MalwareSdo.class, ToolSdo.class}), @RelationshipLimit(source=CampaignSdo.class, relationshipType="attributed-to", target={IntrusionSetSdo.class, ThreatActorSdo.class}), @RelationshipLimit(source=CampaignSdo.class, relationshipType="targets", target={IdentitySdo.class, VulnerabilitySdo.class}), @RelationshipLimit(source=CampaignSdo.class, relationshipType="uses", target={AttackPatternSdo.class, MalwareSdo.class, ToolSdo.class}), @RelationshipLimit(source=CourseOfActionSdo.class, relationshipType="mitigates", target={AttackPatternSdo.class, MalwareSdo.class, ToolSdo.class, VulnerabilitySdo.class}), @RelationshipLimit(source=IndicatorSdo.class, relationshipType="indicates", target={AttackPatternSdo.class, CampaignSdo.class, IntrusionSetSdo.class, MalwareSdo.class, ThreatActorSdo.class, ToolSdo.class}), @RelationshipLimit(source=IntrusionSetSdo.class, relationshipType="attributed-to", target={ThreatActorSdo.class}), @RelationshipLimit(source=IntrusionSetSdo.class, relationshipType="targets", target={IdentitySdo.class, VulnerabilitySdo.class}), @RelationshipLimit(source=IntrusionSetSdo.class, relationshipType="uses", target={AttackPatternSdo.class, MalwareSdo.class, ToolSdo.class}), @RelationshipLimit(source=MalwareSdo.class, relationshipType="targets", target={IdentitySdo.class, VulnerabilitySdo.class}), @RelationshipLimit(source=MalwareSdo.class, relationshipType="uses", target={ToolSdo.class}), @RelationshipLimit(source=MalwareSdo.class, relationshipType="variant-of", target={MalwareSdo.class}), @RelationshipLimit(source=ThreatActorSdo.class, relationshipType="attributed-to", target={IdentitySdo.class}), @RelationshipLimit(source=ThreatActorSdo.class, relationshipType="impersonates", target={IdentitySdo.class}), @RelationshipLimit(source=ThreatActorSdo.class, relationshipType="targets", target={IdentitySdo.class, VulnerabilitySdo.class}), @RelationshipLimit(source=ThreatActorSdo.class, relationshipType="uses", target={AttackPatternSdo.class, MalwareSdo.class, ToolSdo.class}), @RelationshipLimit(source=ToolSdo.class, relationshipType="targets", target={IdentitySdo.class, VulnerabilitySdo.class})})
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Sro"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface RelationshipSro
extends RelationshipObject {
    @NotBlank
    @Vocab(value=RelationshipTypes.class)
    @JsonProperty(value="relationship_type")
    @JsonPropertyDescription(value="The name used to identify the type of relationship.")
    @Redactable(useMask=true)
    public String getRelationshipType();

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A description that helps provide context about the relationship.")
    @Redactable
    public Optional<String> getDescription();

    @NotNull
    @JsonProperty(value="source_ref")
    @JsonPropertyDescription(value="The ID of the source (from) object.")
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    @JsonDeserialize(converter=DomainObjectConverter.class)
    @Redactable(useMask=true)
    public DomainObject getSourceRef();

    @NotNull
    @JsonProperty(value="target_ref")
    @JsonPropertyDescription(value="The ID of the target (to) object.")
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    @JsonDeserialize(converter=DomainObjectConverter.class)
    @Redactable(useMask=true)
    public DomainObject getTargetRef();
}

