/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.sro.objects;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Range;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.common.StixBoolean;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.json.converters.dehydrated.DomainObjectConverter;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.DomainObject;
import security.whisper.javastix.sdo.objects.IdentitySdo;
import security.whisper.javastix.sdo.objects.ObservedDataSdo;
import security.whisper.javastix.sro.RelationshipObject;
import security.whisper.javastix.sro.objects.Sighting;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;

@DefaultTypeValue(value="sighting", groups={DefaultValuesProcessor.class})
@JsonTypeName(value="sighting")
@JsonSerialize(as=Sighting.class)
@JsonDeserialize(builder=Sighting.Builder.class)
@JsonPropertyOrder(value={"type", "id", "created_by_ref", "created", "modified", "revoked", "labels", "external_references", "object_marking_refs", "granular_markings", "first_seen", "last_seen", "count", "sighting_of_ref", "observed_data_refs", "where_sighted_refs", "summary"})
@Redactable
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Sro"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface SightingSro
extends RelationshipObject {
    @JsonProperty(value="first_seen")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The beginning of the time window during which the SDO referenced by the sighting_of_ref property was sighted.")
    @Redactable
    public Optional<StixInstant> getFirstSeen();

    @JsonProperty(value="last_seen")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The end of the time window during which the SDO referenced by the sighting_of_ref property was sighted.")
    @Redactable
    public Optional<StixInstant> getLastSeen();

    @JsonProperty(value="count")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="This is an integer between 0 and 999,999,999 inclusive and represents the number of times the object was sighted.")
    @Redactable
    public Optional<@Range(min=0L, max=999999999L) Integer> getCount();

    @JsonProperty(value="sighting_of_ref")
    @JsonPropertyDescription(value="An ID reference to the object that has been sighted.")
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    @JsonDeserialize(converter=DomainObjectConverter.class)
    @Redactable(useMask=true)
    public DomainObject getSightingOfRef();

    @JsonProperty(value="observed_data_refs")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A list of ID references to the Observed Data objects that contain the raw cyber data for this Sighting.")
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    @JsonDeserialize(contentConverter=DomainObjectConverter.class)
    @Redactable
    @Value.Default
    default public Set<ObservedDataSdo> getObservedDataRefs() {
        return Collections.emptySet();
    }

    @JsonProperty(value="where_sighted_refs")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The ID of the Victim Target objects of the entities that saw the sighting.")
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    @JsonDeserialize(contentConverter=DomainObjectConverter.class)
    @Redactable
    @Value.Default
    default public Set<IdentitySdo> getWhereSightedRefs() {
        return Collections.emptySet();
    }

    @NotNull
    @JsonProperty(value="summary")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The summary property indicates whether the Sighting should be considered summary data.")
    @Redactable
    @Value.Default
    default public StixBoolean isSummary() {
        return new StixBoolean();
    }
}

