/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.validation.constraints.businessrule;

import java.util.Optional;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.SpelCompilerMode;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import security.whisper.javastix.validation.constraints.businessrule.BusinessRule;

public class StixValidateBusinessRuleValidator
implements ConstraintValidator<BusinessRule, Object> {
    private String ifExp;
    private String thenExp;
    private String errorMessage;
    private boolean expectedResult;
    private final SpelParserConfiguration spelConfig = new SpelParserConfiguration(SpelCompilerMode.MIXED, Thread.currentThread().getContextClassLoader());
    private final ExpressionParser parser = new SpelExpressionParser(this.spelConfig);

    public void initialize(BusinessRule constraintAnnotation) {
        this.ifExp = constraintAnnotation.ifExp();
        this.thenExp = constraintAnnotation.thenExp();
        this.errorMessage = constraintAnnotation.errorMessage();
        this.expectedResult = constraintAnnotation.expectedResult();
    }

    public boolean isValid(Object value, ConstraintValidatorContext cxt) {
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
        evaluationContext.setRootObject(value);
        Expression evalIf = this.parser.parseExpression(this.ifExp);
        boolean evalIfResult = Optional.ofNullable((Boolean)evalIf.getValue((EvaluationContext)evaluationContext, Boolean.class)).orElseThrow(() -> new IllegalArgumentException("Unable to parse business rule's ifExp"));
        if (!evalIfResult) {
            return true;
        }
        Expression evalThen = this.parser.parseExpression(this.thenExp);
        boolean evalThenResult = Optional.ofNullable((Boolean)evalThen.getValue((EvaluationContext)evaluationContext, Boolean.class)).orElseThrow(() -> new IllegalArgumentException("Unable to parse business rule's thenExp"));
        if (evalThenResult == this.expectedResult) {
            return true;
        }
        String violationMessage = this.errorMessage;
        cxt.disableDefaultConstraintViolation();
        cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
        return false;
    }
}

