/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.validation.constraints.coo.allowedparents;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import security.whisper.javastix.coo.CyberObservableObject;
import security.whisper.javastix.coo.extension.CyberObservableExtension;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;
import security.whisper.javastix.validation.constraints.coo.allowedparents.ValidateExtensions;

public class StixValidateParentCooValidator
implements ConstraintValidator<ValidateExtensions, CyberObservableObject> {
    public boolean isValid(CyberObservableObject cyberObservableObject, ConstraintValidatorContext cxt) {
        if (cyberObservableObject.getExtensions().size() >= 1) {
            Iterator<CyberObservableExtension> iterator = cyberObservableObject.getExtensions().iterator();
            if (iterator.hasNext()) {
                CyberObservableExtension ext = iterator.next();
                Optional<AllowedParents> annotation = Optional.ofNullable(ext.getClass().getDeclaredAnnotation(AllowedParents.class));
                if (annotation.isPresent()) {
                    Object[] values = annotation.get().value();
                    if (values.length >= 1) {
                        boolean hasAllowedParent = Arrays.stream(values).anyMatch(i -> i.isAssignableFrom(cyberObservableObject.getClass()));
                        if (hasAllowedParent) {
                            return true;
                        }
                        cxt.disableDefaultConstraintViolation();
                        String violationMessage = "Class attempting to use extension is not part of allowedParents interface list found on the Extension.  Calling Cyber Observable Class: " + ext.getClass().getCanonicalName() + " and Extension only supports interfaces: " + Arrays.toString(values);
                        cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
                        return false;
                    }
                    return true;
                }
                return true;
            }
        } else {
            return true;
        }
        return true;
    }
}

