/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.validation.constraints.defaulttypevalue;

import java.lang.reflect.Field;
import java.util.UUID;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import security.whisper.javastix.bundle.BundleObject;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;

public class StixDefaultTypeValueBundleObjectValidator
implements ConstraintValidator<DefaultTypeValue, BundleObject> {
    private String defaultTypeValue;

    public void initialize(DefaultTypeValue relationshipTypeLimitConstraint) {
        this.defaultTypeValue = relationshipTypeLimitConstraint.value();
    }

    public boolean isValid(BundleObject bundleObject, ConstraintValidatorContext cxt) {
        String type = bundleObject.getType();
        if (type == null || type.isEmpty()) {
            try {
                Field typeField = bundleObject.getClass().getDeclaredField("type");
                typeField.setAccessible(true);
                typeField.set(bundleObject, this.defaultTypeValue);
            }
            catch (NoSuchFieldException e) {
                cxt.disableDefaultConstraintViolation();
                String violationMessage = "Cant find Field: 'type' for: " + bundleObject.getClass();
                cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
                e.printStackTrace();
                return false;
            }
            catch (IllegalAccessException e) {
                cxt.disableDefaultConstraintViolation();
                String violationMessage = "Illegal Access Exception for: 'type' for: " + bundleObject.getClass();
                cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
                e.printStackTrace();
                return false;
            }
        } else {
            if (bundleObject.getType().equals(this.defaultTypeValue)) {
                return true;
            }
            cxt.disableDefaultConstraintViolation();
            String violationMessage = "Field 'type' must have value of " + this.defaultTypeValue + "for class " + bundleObject.getClass().getCanonicalName();
            cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
            return false;
        }
        String id = bundleObject.getId();
        if (id == null || id.isEmpty()) {
            try {
                Field idField = bundleObject.getClass().getDeclaredField("id");
                idField.setAccessible(true);
                String idValue = String.join((CharSequence)"--", this.defaultTypeValue, UUID.randomUUID().toString());
                idField.set(bundleObject, idValue);
            }
            catch (IllegalAccessException e) {
                cxt.disableDefaultConstraintViolation();
                String violationMessage = "Illegal Access Exception for: 'id' for: " + bundleObject.getClass();
                cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
                e.printStackTrace();
                return false;
            }
            catch (NoSuchFieldException e) {
                cxt.disableDefaultConstraintViolation();
                String violationMessage = "Cant find Field: 'id' for: " + bundleObject.getClass();
                cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
                e.printStackTrace();
                return false;
            }
        } else {
            boolean idStartsWithType = id.startsWith(this.defaultTypeValue + "--");
            if (!idStartsWithType) {
                cxt.disableDefaultConstraintViolation();
                String violationMessage = "Id does not start with the proper type value(Looking for '" + this.defaultTypeValue + "--' : provided 'id' value was: " + id;
                cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
                return false;
            }
        }
        return true;
    }
}

