/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.validation.constraints.defaulttypevalue;

import java.lang.reflect.Field;
import java.util.UUID;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;

public class StixDefaultTypeValueBundleableValidator
implements ConstraintValidator<DefaultTypeValue, BundleableObject> {
    private String defaultTypeValue;

    public void initialize(DefaultTypeValue relationshipTypeLimitConstraint) {
        this.defaultTypeValue = relationshipTypeLimitConstraint.value();
    }

    public boolean isValid(BundleableObject bundleableObject, ConstraintValidatorContext cxt) {
        String type = bundleableObject.getType();
        if (type == null || type.isEmpty()) {
            try {
                Field typeField = bundleableObject.getClass().getDeclaredField("type");
                typeField.setAccessible(true);
                typeField.set(bundleableObject, this.defaultTypeValue);
            }
            catch (NoSuchFieldException e) {
                cxt.disableDefaultConstraintViolation();
                String violationMessage = "Cant find Field: 'type' for: " + bundleableObject.getClass();
                cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
                e.printStackTrace();
                return false;
            }
            catch (IllegalAccessException e) {
                cxt.disableDefaultConstraintViolation();
                String violationMessage = "Illegal Access Exception for: 'type' for: " + bundleableObject.getClass();
                cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
                e.printStackTrace();
                return false;
            }
        } else {
            if (bundleableObject.getType().equals(this.defaultTypeValue)) {
                return true;
            }
            cxt.disableDefaultConstraintViolation();
            String violationMessage = "Field 'type' must have value of " + this.defaultTypeValue + "for class " + bundleableObject.getClass().getCanonicalName();
            cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
            return false;
        }
        String id = bundleableObject.getId();
        if (id == null || id.isEmpty()) {
            try {
                Field idField = bundleableObject.getClass().getDeclaredField("id");
                idField.setAccessible(true);
                String idValue = String.join((CharSequence)"--", this.defaultTypeValue, UUID.randomUUID().toString());
                idField.set(bundleableObject, idValue);
            }
            catch (IllegalAccessException e) {
                cxt.disableDefaultConstraintViolation();
                String violationMessage = "Illegal Access Exception for: 'id' for: " + bundleableObject.getClass();
                cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
                e.printStackTrace();
                return false;
            }
            catch (NoSuchFieldException e) {
                cxt.disableDefaultConstraintViolation();
                String violationMessage = "Cant find Field: 'id' for: " + bundleableObject.getClass();
                cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
                e.printStackTrace();
                return false;
            }
        } else {
            boolean idStartsWithType = id.startsWith(this.defaultTypeValue + "--");
            if (!idStartsWithType) {
                cxt.disableDefaultConstraintViolation();
                String violationMessage = "Id does not start with the proper type value(Looking for '" + this.defaultTypeValue + "--' : provided 'id' value was: " + id;
                cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
                return false;
            }
        }
        return true;
    }
}

