/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.validation.constraints.defaulttypevalue;

import java.lang.reflect.Field;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import security.whisper.javastix.coo.extension.CyberObservableExtension;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;

public class StixDefaultTypeValueCyberObservableExtensionValidator
implements ConstraintValidator<DefaultTypeValue, CyberObservableExtension> {
    private String defaultTypeValue;

    public void initialize(DefaultTypeValue relationshipTypeLimitConstraint) {
        this.defaultTypeValue = relationshipTypeLimitConstraint.value();
    }

    public boolean isValid(CyberObservableExtension cyberObservableExtension, ConstraintValidatorContext cxt) {
        String type = cyberObservableExtension.getType();
        if (type == null || type.isEmpty()) {
            try {
                Field typeField = cyberObservableExtension.getClass().getDeclaredField("type");
                typeField.setAccessible(true);
                typeField.set(cyberObservableExtension, this.defaultTypeValue);
            }
            catch (NoSuchFieldException e) {
                cxt.disableDefaultConstraintViolation();
                String violationMessage = "Cant find Field: 'type' for: " + cyberObservableExtension.getClass();
                cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
                e.printStackTrace();
                return false;
            }
            catch (IllegalAccessException e) {
                cxt.disableDefaultConstraintViolation();
                String violationMessage = "Illegal Access Exception for: 'type' for: " + cyberObservableExtension.getClass();
                cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
                e.printStackTrace();
                return false;
            }
        } else {
            if (cyberObservableExtension.getType().equals(this.defaultTypeValue)) {
                return true;
            }
            cxt.disableDefaultConstraintViolation();
            String violationMessage = "Field 'type' must have value of " + this.defaultTypeValue + "for class " + cyberObservableExtension.getClass().getCanonicalName();
            cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
            return false;
        }
        return true;
    }
}

