/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.validation.constraints.defaulttypevalue;

import java.lang.reflect.Field;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import security.whisper.javastix.coo.CyberObservableObject;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;

public class StixDefaultTypeValueCyberObservableValidator
implements ConstraintValidator<DefaultTypeValue, CyberObservableObject> {
    private String defaultTypeValue;

    public void initialize(DefaultTypeValue relationshipTypeLimitConstraint) {
        this.defaultTypeValue = relationshipTypeLimitConstraint.value();
    }

    public boolean isValid(CyberObservableObject cyberObservableObject, ConstraintValidatorContext cxt) {
        String type = cyberObservableObject.getType();
        if (type == null || type.isEmpty()) {
            try {
                Field typeField = cyberObservableObject.getClass().getDeclaredField("type");
                typeField.setAccessible(true);
                typeField.set(cyberObservableObject, this.defaultTypeValue);
            }
            catch (NoSuchFieldException e) {
                cxt.disableDefaultConstraintViolation();
                String violationMessage = "Cant find Field: 'type' for: " + cyberObservableObject.getClass();
                cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
                e.printStackTrace();
                return false;
            }
            catch (IllegalAccessException e) {
                cxt.disableDefaultConstraintViolation();
                String violationMessage = "Illegal Access Exception for: 'type' for: " + cyberObservableObject.getClass();
                cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
                e.printStackTrace();
                return false;
            }
        } else {
            if (cyberObservableObject.getType().equals(this.defaultTypeValue)) {
                return true;
            }
            cxt.disableDefaultConstraintViolation();
            String violationMessage = "Field 'type' must have value of " + this.defaultTypeValue + "for class " + cyberObservableObject.getClass().getCanonicalName();
            cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
            return false;
        }
        return true;
    }
}

