/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.validation.constraints.hashingvocab;

import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import security.whisper.javastix.validation.constraints.hashingvocab.HashingVocab;
import security.whisper.javastix.vocabulary.StixVocabulary;

public class StixHashingVocabValidatorString
implements ConstraintValidator<HashingVocab, String> {
    private Class<? extends StixVocabulary> vocabulary;

    public void initialize(HashingVocab hashingVocabConstraint) {
        this.vocabulary = hashingVocabConstraint.value();
    }

    public boolean isValid(String vocab, ConstraintValidatorContext cxt) {
        if (vocab.startsWith("x_")) {
            return true;
        }
        try {
            Set<String> vocabTerms = this.vocabulary.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).getAllTerms();
            boolean evalContains = vocabTerms.contains(vocab);
            if (!evalContains) {
                Sets.SetView difference = Sets.difference(new HashSet<String>(Collections.singletonList(vocab)), vocabTerms);
                cxt.disableDefaultConstraintViolation();
                String violationMessage = "Item: " + difference + " is not found in class " + this.vocabulary.getCanonicalName();
                cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
                return false;
            }
            return true;
        }
        catch (InstantiationException e) {
            cxt.disableDefaultConstraintViolation();
            String violationMessage = "InstantiationException from " + this.vocabulary.getSimpleName();
            cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
            return false;
        }
        catch (IllegalAccessException e) {
            cxt.disableDefaultConstraintViolation();
            String violationMessage = "IllegalAccessException from " + this.vocabulary.getSimpleName();
            cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
            return false;
        }
        catch (NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

