/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.validation.constraints.markingdefinitiontype;

import java.lang.reflect.Field;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import security.whisper.javastix.datamarkings.MarkingDefinitionDm;
import security.whisper.javastix.datamarkings.StixMarkingObject;
import security.whisper.javastix.validation.constraints.markingdefinitiontype.MarkingDefinitionTypeLimit;

public class StixMarkingDefinitionTypeLimitValidator
implements ConstraintValidator<MarkingDefinitionTypeLimit, MarkingDefinitionDm> {
    private Class<? extends StixMarkingObject> markingObject;
    private String markingDefinitionType;

    public void initialize(MarkingDefinitionTypeLimit markingDefinitionTypeLimitConstraint) {
        this.markingObject = markingDefinitionTypeLimitConstraint.markingObject();
        this.markingDefinitionType = markingDefinitionTypeLimitConstraint.markingDefinitionType();
    }

    public boolean isValid(MarkingDefinitionDm markingDefinitionDm, ConstraintValidatorContext cxt) {
        if (markingDefinitionDm.getHydrated()) {
            if (markingDefinitionDm.getDefinition() == null) {
                cxt.disableDefaultConstraintViolation();
                String violationMessage = "Definition attribute of a Marking Definition cannot be null";
                cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
                return false;
            }
            if (markingDefinitionDm.getDefinitionType() == null && this.markingObject.isAssignableFrom(markingDefinitionDm.getDefinition().getClass())) {
                try {
                    Field typeField = markingDefinitionDm.getClass().getDeclaredField("definitionType");
                    typeField.setAccessible(true);
                    typeField.set(markingDefinitionDm, this.markingDefinitionType);
                }
                catch (NoSuchFieldException e) {
                    cxt.disableDefaultConstraintViolation();
                    String violationMessage = "Cant find Field: 'definitionType' for: " + this.markingObject;
                    cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
                    e.printStackTrace();
                    return false;
                }
                catch (IllegalAccessException e) {
                    cxt.disableDefaultConstraintViolation();
                    String violationMessage = "Illegal Access Exception for: 'definitionType' for: " + this.markingObject;
                    cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
                    e.printStackTrace();
                    return false;
                }
            }
            if (this.markingObject.isAssignableFrom(markingDefinitionDm.getDefinition().getClass())) {
                if (markingDefinitionDm.getDefinitionType().equals(this.markingDefinitionType)) {
                    return true;
                }
                cxt.disableDefaultConstraintViolation();
                String violationMessage = "Marking Definition Type is incorrect for Marking Object";
                cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
                return false;
            }
            return true;
        }
        return true;
    }
}

