/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.validation.constraints.relationship;

import java.util.Arrays;
import java.util.stream.Collectors;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import security.whisper.javastix.sdo.DomainObject;
import security.whisper.javastix.sro.objects.RelationshipSro;
import security.whisper.javastix.validation.constraints.relationship.RelationshipLimit;

public class StixRelationshipLimitValidator
implements ConstraintValidator<RelationshipLimit, RelationshipSro> {
    private Class<? extends DomainObject> source;
    private String relationshipType;
    private Class<? extends DomainObject>[] target;
    private boolean classEquality;

    public void initialize(RelationshipLimit relationshipLimit) {
        this.source = relationshipLimit.source();
        this.target = relationshipLimit.target();
        this.relationshipType = relationshipLimit.relationshipType();
        this.classEquality = relationshipLimit.classEquality();
    }

    public boolean isValid(RelationshipSro object, ConstraintValidatorContext cxt) {
        if (object.getRelationshipType().equals(this.relationshipType)) {
            if (this.classEquality && !object.getSourceRef().getClass().equals(object.getTargetRef().getClass())) {
                cxt.disableDefaultConstraintViolation();
                String violationMessage = "Class Equality mismatch: Source: " + this.source.getCanonicalName() + " does not match Target: " + object.getTargetRef().getClass().getCanonicalName();
                cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
                return false;
            }
            if (this.source.isAssignableFrom(object.getSourceRef().getClass())) {
                boolean hasInstance = Arrays.stream(this.target).anyMatch(t -> t.isAssignableFrom(object.getTargetRef().getClass()));
                if (this.classEquality && object.getTargetRef().getClass().equals(object.getSourceRef().getClass())) {
                    return true;
                }
                if (hasInstance) {
                    return true;
                }
                cxt.disableDefaultConstraintViolation();
                String targetClasses = Arrays.stream(this.target).map(Class::getCanonicalName).collect(Collectors.toList()).toString();
                String violationMessage = "Source/Target/RelationshipType Mismatch: Source: " + this.source.getCanonicalName() + " with Relationship-Type '" + this.relationshipType + "' is only supported for Target(s): " + targetClasses;
                cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
                return false;
            }
            return true;
        }
        return true;
    }
}

