/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.validation.constraints.relationship;

import java.util.Arrays;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import security.whisper.javastix.sdo.DomainObject;
import security.whisper.javastix.sro.objects.RelationshipSro;
import security.whisper.javastix.validation.constraints.relationship.RelationshipTypeLimit;

public class StixRelationshipTypeLimitValidator
implements ConstraintValidator<RelationshipTypeLimit, RelationshipSro> {
    private Class<? extends DomainObject> source;
    private String[] relationshipTypes;
    private String[] commonRelationshipsTypes;
    private boolean enforceCommonRelationshipTypes;

    public void initialize(RelationshipTypeLimit relationshipTypeLimitConstraint) {
        this.source = relationshipTypeLimitConstraint.source();
        this.relationshipTypes = relationshipTypeLimitConstraint.relationshipTypes();
        this.commonRelationshipsTypes = relationshipTypeLimitConstraint.commonRelationshipTypes();
        this.enforceCommonRelationshipTypes = relationshipTypeLimitConstraint.enforceCommonRelationshipTypes();
    }

    public boolean isValid(RelationshipSro relationshipSro, ConstraintValidatorContext cxt) {
        if (this.source.isAssignableFrom(relationshipSro.getSourceRef().getClass())) {
            List<String> typesList = Arrays.asList(this.relationshipTypes);
            List<String> commonTypesList = Arrays.asList(this.commonRelationshipsTypes);
            if (typesList.contains(relationshipSro.getRelationshipType())) {
                return true;
            }
            if (this.enforceCommonRelationshipTypes && commonTypesList.contains(relationshipSro.getRelationshipType())) {
                return true;
            }
            cxt.disableDefaultConstraintViolation();
            String violationMessage = "Relationship Type: '" + relationshipSro.getRelationshipType() + "' is not supported with class " + relationshipSro.getClass().getCanonicalName();
            cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
            return false;
        }
        return true;
    }
}

