/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.validation.constraints.startswith;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import security.whisper.javastix.validation.constraints.startswith.StartsWith;

public class StixStartsWithValidatorString
implements ConstraintValidator<StartsWith, String> {
    private String prefix;

    public void initialize(StartsWith startsWithConstraint) {
        this.prefix = startsWithConstraint.value();
    }

    public boolean isValid(String value, ConstraintValidatorContext cxt) {
        if (value.startsWith(this.prefix)) {
            return true;
        }
        cxt.disableDefaultConstraintViolation();
        String violationMessage = "StartsWith violation: string must start with value: " + this.prefix + ", but provided value: " + value;
        cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
        return false;
    }
}

