/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.validation.constraints.vocab;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import security.whisper.javastix.validation.constraints.vocab.Vocab;
import security.whisper.javastix.vocabulary.StixVocabulary;

public class StixVocabValidatorOptionalString
implements ConstraintValidator<Vocab, Optional<String>> {
    private Class<? extends StixVocabulary> vocabulary;

    public void initialize(Vocab vocabConstraint) {
        this.vocabulary = vocabConstraint.value();
    }

    public boolean isValid(Optional<String> vocab, ConstraintValidatorContext cxt) {
        if (vocab.isPresent()) {
            try {
                Set<String> vocabTerms = this.vocabulary.newInstance().getAllTerms();
                boolean evalContains = vocabTerms.contains(vocab.get());
                if (!evalContains) {
                    Sets.SetView difference = Sets.difference(new HashSet<String>(Arrays.asList(vocab.get())), vocabTerms);
                    cxt.disableDefaultConstraintViolation();
                    String violationMessage = "Item: " + difference.toString() + " is not found in class " + this.vocabulary.getCanonicalName();
                    cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
                }
                return evalContains;
            }
            catch (InstantiationException e) {
                cxt.disableDefaultConstraintViolation();
                String violationMessage = "InstantiationException from " + this.vocabulary.getSimpleName();
                cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
                e.printStackTrace();
                return false;
            }
            catch (IllegalAccessException e) {
                cxt.disableDefaultConstraintViolation();
                String violationMessage = "IllegalAccessException from " + this.vocabulary.getSimpleName();
                cxt.buildConstraintViolationWithTemplate(violationMessage).addConstraintViolation();
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }
}

