/*
 * Decompiled with CFR 0.152.
 */
package sn.sonatel.api.model;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class TransactionRequest {
    private String partnerMsisdn;
    private String partnerEncryptedPinCode;
    @NonNull
    private Float amount;
    @NonNull
    private String customerMsisdn;
    private Map<String, String> metadata = new HashMap<String, String>();
    private String reference;
    private Instant requestDate;
    private boolean receivedNotification = true;

    TransactionRequest(String partnerMsisdn, String partnerEncryptedPinCode, @NonNull Float amount, @NonNull String customerMsisdn, Map<String, String> metadata, String reference, Instant requestDate, boolean receivedNotification) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (customerMsisdn == null) {
            throw new NullPointerException("customerMsisdn is marked non-null but is null");
        }
        this.partnerMsisdn = partnerMsisdn;
        this.partnerEncryptedPinCode = partnerEncryptedPinCode;
        this.amount = amount;
        this.customerMsisdn = customerMsisdn;
        this.metadata = metadata;
        this.reference = reference;
        this.requestDate = requestDate;
        this.receivedNotification = receivedNotification;
    }

    public static TransactionRequestBuilder builder() {
        return new TransactionRequestBuilder();
    }

    public String getPartnerMsisdn() {
        return this.partnerMsisdn;
    }

    public String getPartnerEncryptedPinCode() {
        return this.partnerEncryptedPinCode;
    }

    @NonNull
    public Float getAmount() {
        return this.amount;
    }

    @NonNull
    public String getCustomerMsisdn() {
        return this.customerMsisdn;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String getReference() {
        return this.reference;
    }

    public Instant getRequestDate() {
        return this.requestDate;
    }

    public boolean isReceivedNotification() {
        return this.receivedNotification;
    }

    public static class TransactionRequestBuilder {
        private String partnerMsisdn;
        private String partnerEncryptedPinCode;
        private Float amount;
        private String customerMsisdn;
        private Map<String, String> metadata;
        private String reference;
        private Instant requestDate;
        private boolean receivedNotification;

        TransactionRequestBuilder() {
        }

        public TransactionRequestBuilder partnerMsisdn(String partnerMsisdn) {
            this.partnerMsisdn = partnerMsisdn;
            return this;
        }

        public TransactionRequestBuilder partnerEncryptedPinCode(String partnerEncryptedPinCode) {
            this.partnerEncryptedPinCode = partnerEncryptedPinCode;
            return this;
        }

        public TransactionRequestBuilder amount(@NonNull Float amount) {
            if (amount == null) {
                throw new NullPointerException("amount is marked non-null but is null");
            }
            this.amount = amount;
            return this;
        }

        public TransactionRequestBuilder customerMsisdn(@NonNull String customerMsisdn) {
            if (customerMsisdn == null) {
                throw new NullPointerException("customerMsisdn is marked non-null but is null");
            }
            this.customerMsisdn = customerMsisdn;
            return this;
        }

        public TransactionRequestBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public TransactionRequestBuilder reference(String reference) {
            this.reference = reference;
            return this;
        }

        public TransactionRequestBuilder requestDate(Instant requestDate) {
            this.requestDate = requestDate;
            return this;
        }

        public TransactionRequestBuilder receivedNotification(boolean receivedNotification) {
            this.receivedNotification = receivedNotification;
            return this;
        }

        public TransactionRequest build() {
            return new TransactionRequest(this.partnerMsisdn, this.partnerEncryptedPinCode, this.amount, this.customerMsisdn, this.metadata, this.reference, this.requestDate, this.receivedNotification);
        }

        public String toString() {
            return "TransactionRequest.TransactionRequestBuilder(partnerMsisdn=" + this.partnerMsisdn + ", partnerEncryptedPinCode=" + this.partnerEncryptedPinCode + ", amount=" + this.amount + ", customerMsisdn=" + this.customerMsisdn + ", metadata=" + this.metadata + ", reference=" + this.reference + ", requestDate=" + this.requestDate + ", receivedNotification=" + this.receivedNotification + ")";
        }
    }
}

