/*
 * Decompiled with CFR 0.152.
 */
package sn.sonatel.api.model;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class TransactionRequest {
    private String partnerMsisdn;
    private String partnerEncryptedPinCode;
    @NonNull
    private Float amount;
    @NonNull
    private String customerMsisdn;
    private Map<String, String> metadata = new HashMap<String, String>();
    private String reference;
    private Instant requestDate;
    private boolean receivedNotification = true;

    protected TransactionRequest(@NonNull Float amount, @NonNull String customerMsisdn) {
        this.withAmount(amount);
        this.withCustomerMsisdn(customerMsisdn);
    }

    public TransactionRequest withPartnerMsisdn(@NonNull String partnerMsisdn) {
        Assert.notNull((Object)partnerMsisdn, (String)"Partner msisdn is required");
        this.partnerMsisdn = partnerMsisdn;
        return this;
    }

    public TransactionRequest withPartnerEncryptedPinCode(@NonNull String partnerEncryptedPinCode) {
        Assert.notNull((Object)partnerEncryptedPinCode, (String)"Partner encrypted pin code is required");
        this.partnerEncryptedPinCode = partnerEncryptedPinCode;
        return this;
    }

    public TransactionRequest withAmount(@NonNull Float amount) {
        Assert.notNull((Object)amount, (String)"Amount is required");
        this.amount = amount;
        return this;
    }

    public TransactionRequest withCustomerMsisdn(@NonNull String customerMsisdn) {
        Assert.notNull((Object)customerMsisdn, (String)"Customer msisdn is required");
        this.customerMsisdn = customerMsisdn;
        return this;
    }

    public TransactionRequest withRequestDate(Instant requestDate) {
        this.requestDate = requestDate;
        return this;
    }

    public TransactionRequest withReference(String reference) {
        this.reference = reference;
        return this;
    }

    public TransactionRequest withMetadata(@NonNull Map<String, String> metadata) {
        if (!CollectionUtils.isEmpty(metadata)) {
            this.metadata = metadata;
        }
        return this;
    }

    public TransactionRequest allowNotification(boolean receivedNotification) {
        this.receivedNotification = receivedNotification;
        return this;
    }

    public static TransactionRequest forAmountAndCustomer(@NonNull Float amount, @NonNull String customerMsisdn) {
        return new TransactionRequest(amount, customerMsisdn);
    }

    public String getPartnerMsisdn() {
        return this.partnerMsisdn;
    }

    public String getPartnerEncryptedPinCode() {
        return this.partnerEncryptedPinCode;
    }

    @NonNull
    public Float getAmount() {
        return this.amount;
    }

    @NonNull
    public String getCustomerMsisdn() {
        return this.customerMsisdn;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String getReference() {
        return this.reference;
    }

    public Instant getRequestDate() {
        return this.requestDate;
    }

    public boolean isReceivedNotification() {
        return this.receivedNotification;
    }
}

