/*
 * Decompiled with CFR 0.152.
 */
package sn.sonatel.api.service.mapper;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.ObjectUtils;
import sn.sonatel.api.model.Money;
import sn.sonatel.api.model.RelatedParty;
import sn.sonatel.api.model.Transaction;
import sn.sonatel.api.model.TransactionRequest;

public interface RequestMapper {
    public static Transaction mapTransactionRequest(TransactionRequest source, String defaultPartnerMsisdn, String defaultPinCode) {
        Transaction transaction = new Transaction();
        transaction.setRequestDate((Instant)ObjectUtils.defaultIfNull((Object)source.getRequestDate(), (Object)Instant.now()));
        transaction.setReference((String)ObjectUtils.defaultIfNull((Object)source.getReference(), (Object)UUID.randomUUID().toString()));
        transaction.setMetadata((Map)ObjectUtils.defaultIfNull((Object)source.getMetadata(), new HashMap()));
        transaction.setAmount(new Money(source.getAmount()));
        RelatedParty partner = new RelatedParty();
        partner.setId((String)ObjectUtils.defaultIfNull((Object)source.getPartnerMsisdn(), (Object)defaultPartnerMsisdn));
        partner.setEncryptedPinCode((String)ObjectUtils.defaultIfNull((Object)source.getPartnerEncryptedPinCode(), (Object)defaultPinCode));
        transaction.setPartner(partner);
        RelatedParty customer = new RelatedParty();
        customer.setId(source.getCustomerMsisdn());
        transaction.setCustomer(customer);
        return transaction;
    }
}

