/*
 * Decompiled with CFR 0.152.
 */
package sn.sonatel.api.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import sn.sonatel.api.autoconfigure.SonatelSdkProperties;
import sn.sonatel.api.model.PublicKey;
import sn.sonatel.api.model.Transaction;
import sn.sonatel.api.model.TransactionRequest;
import sn.sonatel.api.model.TransactionResponse;
import sn.sonatel.api.model.exception.ClientResponseException;
import sn.sonatel.api.model.exception.ErrorDetails;
import sn.sonatel.api.service.EncryptionService;
import sn.sonatel.api.service.TransactionService;
import sn.sonatel.api.service.mapper.RequestMapper;

public class TransactionServiceImpl
implements TransactionService {
    private static final Logger log = LoggerFactory.getLogger(TransactionServiceImpl.class);
    private final WebClient webClient;
    private final EncryptionService encryptionService;
    private final SonatelSdkProperties sonatelSdkProperties;

    public TransactionServiceImpl(EncryptionService encryptionService, @Qualifier(value="SONATEL") WebClient webClient, SonatelSdkProperties sonatelSdkProperties) {
        this.webClient = webClient;
        this.encryptionService = encryptionService;
        this.sonatelSdkProperties = sonatelSdkProperties;
    }

    public TransactionResponse cashIn(TransactionRequest request) {
        Transaction transaction = RequestMapper.mapTransactionRequest(request, this.sonatelSdkProperties.getMyMsisdn(), this.encryptionService.getMyEncodedPinCode());
        log.info("Sending request {}", (Object)transaction);
        return this.sendRequest(transaction, this.sonatelSdkProperties.getCashinUri());
    }

    public PublicKey getPublicKey() {
        return this.encryptionService.getPublicKey();
    }

    private TransactionResponse sendRequest(Transaction request, String uri) {
        return (TransactionResponse)((WebClient.RequestBodySpec)this.webClient.post().uri(this.sonatelSdkProperties.getBaseUrl() + uri, new Object[0])).contentType(MediaType.APPLICATION_JSON).bodyValue((Object)request).accept(new MediaType[]{MediaType.APPLICATION_JSON}).retrieve().onStatus(HttpStatus::isError, response -> response.bodyToMono(ErrorDetails.class).flatMap(errorDetails -> {
            log.error("Failed to process transaction due to : {}", errorDetails);
            return Mono.error((Throwable)new ClientResponseException(response.statusCode(), errorDetails));
        })).bodyToMono(TransactionResponse.class).block();
    }
}

