/*
 * Decompiled with CFR 0.152.
 */
package sn.sonatel.api.service;

import com.nimbusds.jose.jwk.KeyType;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.tomcat.util.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.reactive.function.client.WebClient;
import sn.sonatel.api.autoconfigure.SonatelSdkProperties;
import sn.sonatel.api.model.PublicKey;
import sn.sonatel.api.service.EncryptionService;

public class EncryptionServiceImpl
implements EncryptionService {
    private static final Logger log = LoggerFactory.getLogger(EncryptionServiceImpl.class);
    private PublicKey publicKey;
    private String retailerEncodedPinCode;
    private String merchantEncodedPinCode;
    private final SonatelSdkProperties applicationProperties;
    private final WebClient webClient;

    public EncryptionServiceImpl(@Qualifier(value="SONATEL") WebClient webClient, SonatelSdkProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
        this.webClient = webClient;
    }

    public String encrypt(String message) throws IllegalArgumentException {
        try {
            Cipher cipher = Cipher.getInstance(KeyType.RSA.toString());
            byte[] publicKeyBytes = Base64.decodeBase64((String)this.getPublicKey().getKey());
            KeyFactory publicKeyFactory = KeyFactory.getInstance(KeyType.RSA.toString());
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(publicKeyBytes);
            java.security.PublicKey key = publicKeyFactory.generatePublic(publicKeySpec);
            cipher.init(1, key);
            return Objects.isNull(message) ? null : Base64.encodeBase64String((byte[])cipher.doFinal(message.getBytes(StandardCharsets.UTF_8)));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            log.error("Failed to encrypt message", (Throwable)ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public String getRetailerAccountEncodedPinCode() {
        return this.retailerEncodedPinCode;
    }

    public String getMerchantAccountEncodedPinCode() {
        return this.merchantEncodedPinCode;
    }

    @PostConstruct
    void initProperties() {
        this.publicKey = (PublicKey)this.webClient.get().uri(this.applicationProperties.getBaseUrl() + this.applicationProperties.getPublicKeyUri(), new Object[0]).retrieve().bodyToMono(PublicKey.class).block();
        Optional.ofNullable(this.applicationProperties.getRetailer()).ifPresent(retailer -> {
            this.retailerEncodedPinCode = this.encrypt(retailer.getPinCode());
        });
        Optional.ofNullable(this.applicationProperties.getMerchant()).ifPresent(merchant -> {
            this.merchantEncodedPinCode = this.encrypt(merchant.getPinCode());
        });
        Optional.ofNullable(this.publicKey).ifPresent(key -> log.info("retrieved  public key is : {}...", (Object)this.publicKey.getKey().substring(100)));
    }
}

