/*
 * Decompiled with CFR 0.152.
 */
package sn.sonatel.api.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import sn.sonatel.api.autoconfigure.SonatelSdkProperties;
import sn.sonatel.api.model.Money;
import sn.sonatel.api.model.PublicKey;
import sn.sonatel.api.model.RelatedParty;
import sn.sonatel.api.model.Transaction;
import sn.sonatel.api.model.TransactionRequest;
import sn.sonatel.api.model.TransactionResponse;
import sn.sonatel.api.model.exception.ClientResponseException;
import sn.sonatel.api.model.exception.ErrorDetails;
import sn.sonatel.api.service.EncryptionService;
import sn.sonatel.api.service.TransactionService;
import sn.sonatel.api.service.mapper.RequestMapper;

public class TransactionServiceImpl
implements TransactionService {
    private static final Logger log = LoggerFactory.getLogger(TransactionServiceImpl.class);
    private final WebClient webClient;
    private final EncryptionService encryptionService;
    private final SonatelSdkProperties sonatelSdkProperties;

    public TransactionServiceImpl(EncryptionService encryptionService, @Qualifier(value="SONATEL") WebClient webClient, SonatelSdkProperties sonatelSdkProperties) {
        this.webClient = webClient;
        this.encryptionService = encryptionService;
        this.sonatelSdkProperties = sonatelSdkProperties;
    }

    public PublicKey getPublicKey() {
        return this.encryptionService.getPublicKey();
    }

    public Float getRetailerBalance() throws ClientResponseException {
        RelatedParty relatedParty = new RelatedParty();
        relatedParty.setId(this.sonatelSdkProperties.getRetailer().getMsisdn());
        relatedParty.setEncryptedPinCode(this.encryptionService.getRetailerAccountEncodedPinCode());
        return this.getBalance(relatedParty, this.sonatelSdkProperties.getBalanceUri());
    }

    public Float getMerchantBalance() throws ClientResponseException {
        RelatedParty relatedParty = new RelatedParty();
        relatedParty.setId(this.sonatelSdkProperties.getMerchant().getMsisdn());
        relatedParty.setEncryptedPinCode(this.encryptionService.getMerchantAccountEncodedPinCode());
        return this.getBalance(relatedParty, this.sonatelSdkProperties.getBalanceUri());
    }

    public TransactionResponse cashIn(TransactionRequest request) {
        Transaction transaction = RequestMapper.mapTransactionRequest(request, this.sonatelSdkProperties.getRetailer().getMsisdn(), this.encryptionService.getRetailerAccountEncodedPinCode());
        log.info("Sending cashin request {}", (Object)transaction);
        return this.sendRequest(transaction, this.sonatelSdkProperties.getCashinUri());
    }

    public TransactionResponse webPayment(TransactionRequest request) throws ClientResponseException {
        Transaction transaction = RequestMapper.webPayment(request, this.sonatelSdkProperties.getMerchant().getMsisdn(), this.encryptionService.getMerchantAccountEncodedPinCode());
        log.info("Sending web payment request {}", (Object)transaction);
        return this.sendRequest(transaction, this.sonatelSdkProperties.getWebPayment());
    }

    private TransactionResponse sendRequest(Transaction request, String uri) {
        return (TransactionResponse)((WebClient.RequestBodySpec)this.webClient.post().uri(this.sonatelSdkProperties.getBaseUrl() + uri, new Object[0])).contentType(MediaType.APPLICATION_JSON).bodyValue((Object)request).accept(new MediaType[]{MediaType.APPLICATION_JSON}).retrieve().onStatus(HttpStatus::isError, response -> response.bodyToMono(ErrorDetails.class).flatMap(errorDetails -> {
            log.error("Failed to process transaction due to : {}", errorDetails);
            return Mono.error((Throwable)new ClientResponseException(response.statusCode(), errorDetails));
        })).bodyToMono(TransactionResponse.class).block();
    }

    private Float getBalance(RelatedParty party, String uri) {
        return ((Money)((WebClient.RequestBodySpec)this.webClient.post().uri(this.sonatelSdkProperties.getBaseUrl() + uri, new Object[0])).contentType(MediaType.APPLICATION_JSON).bodyValue((Object)party).accept(new MediaType[]{MediaType.APPLICATION_JSON}).retrieve().onStatus(HttpStatus::isError, response -> response.bodyToMono(ErrorDetails.class).flatMap(errorDetails -> {
            log.error("Failed to process transaction due to : {}", errorDetails);
            return Mono.error((Throwable)new ClientResponseException(response.statusCode(), errorDetails));
        })).bodyToMono(Money.class).block()).getValue();
    }
}

