/*
 * Decompiled with CFR 0.152.
 */
package sn.sonatel.api.autoconfigure;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.AuthorizedClientServiceReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.InMemoryReactiveOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.InMemoryReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.reactive.function.client.ServerOAuth2AuthorizedClientExchangeFilterFunction;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;
import sn.sonatel.api.autoconfigure.SonatelSdkProperties;
import sn.sonatel.api.exceptions.ApiExceptionHandler;
import sn.sonatel.api.service.EncryptionService;
import sn.sonatel.api.service.EncryptionServiceImpl;
import sn.sonatel.api.service.TransactionService;
import sn.sonatel.api.service.TransactionServiceImpl;

@AutoConfiguration
@EnableConfigurationProperties(value={SonatelSdkProperties.class})
@ConditionalOnProperty(prefix="sonatel", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class SonatelSdkAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SonatelSdkAutoConfiguration.class);

    @Configuration(proxyBeanMethods=false)
    static class BuilderConfiguration {
        private final SonatelSdkProperties properties;
        private static final String ID = "sonatel";

        BuilderConfiguration(SonatelSdkProperties properties) {
            this.properties = properties;
        }

        @Bean
        public ReactiveClientRegistrationRepository clientRegistrations() {
            ClientRegistration registration = ClientRegistration.withRegistrationId((String)ID).tokenUri(this.properties.getSecurity().getTokenUrl()).clientId(this.properties.getSecurity().getClientId()).clientSecret(this.properties.getSecurity().getClientSecret()).scope(new String[]{"email"}).authorizationGrantType(new AuthorizationGrantType(AuthorizationGrantType.CLIENT_CREDENTIALS.getValue())).build();
            return new InMemoryReactiveClientRegistrationRepository(new ClientRegistration[]{registration});
        }

        @Bean
        @Qualifier(value="SONATEL")
        public WebClient webClient(ReactiveClientRegistrationRepository clientRegistrations) {
            InMemoryReactiveOAuth2AuthorizedClientService clientService = new InMemoryReactiveOAuth2AuthorizedClientService(clientRegistrations);
            AuthorizedClientServiceReactiveOAuth2AuthorizedClientManager authorizedClientManager = new AuthorizedClientServiceReactiveOAuth2AuthorizedClientManager(clientRegistrations, (ReactiveOAuth2AuthorizedClientService)clientService);
            ServerOAuth2AuthorizedClientExchangeFilterFunction oauth = new ServerOAuth2AuthorizedClientExchangeFilterFunction((ReactiveOAuth2AuthorizedClientManager)authorizedClientManager);
            oauth.setDefaultClientRegistrationId(ID);
            return WebClient.builder().filter((ExchangeFilterFunction)oauth).build();
        }

        @Bean
        public EncryptionService encryption(@Qualifier(value="SONATEL") WebClient webClient, SonatelSdkProperties applicationProperties) {
            return new EncryptionServiceImpl(webClient, applicationProperties);
        }

        @Bean
        public TransactionService transaction(EncryptionService encryptionService, WebClient webClient, SonatelSdkProperties applicationProperties) {
            return new TransactionServiceImpl(encryptionService, webClient, applicationProperties);
        }

        @Bean
        public ApiExceptionHandler exceptionHandler() {
            return new ApiExceptionHandler();
        }
    }
}

