/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicefairlink;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.services.rds.AmazonRDSAsync;
import com.amazonaws.services.rds.AmazonRDSAsyncClient;
import com.amazonaws.services.rds.AmazonRDSAsyncClientBuilder;
import com.amazonaws.services.rds.model.DBCluster;
import com.amazonaws.services.rds.model.DBClusterMember;
import com.amazonaws.services.rds.model.DBInstance;
import com.amazonaws.services.rds.model.DescribeDBClustersRequest;
import com.amazonaws.services.rds.model.DescribeDBClustersResult;
import com.amazonaws.services.rds.model.DescribeDBInstancesRequest;
import com.amazonaws.services.rds.model.DescribeDBInstancesResult;
import com.amazonaws.services.rds.model.Endpoint;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import technology.dice.dicefairlink.iterators.RandomisedCyclicIterator;

public class AuroraReadonlyEndpoint {
    private static final Logger LOGGER = Logger.getLogger(AuroraReadonlyEndpoint.class.getName());
    private static final String ACTIVE_STATUS = "available";
    private final Duration pollerInterval;
    private RandomisedCyclicIterator<String> replicas;
    private String readOnlyEndpoint;

    public AuroraReadonlyEndpoint(String clusterId, AWSCredentialsProvider credentialsProvider, Duration pollerInterval, Region region, ScheduledExecutorService executor) {
        AuroraReplicasFinder finder = new AuroraReplicasFinder(clusterId, credentialsProvider, region);
        this.pollerInterval = pollerInterval;
        finder.init();
        executor.scheduleAtFixedRate(finder, pollerInterval.getSeconds(), pollerInterval.getSeconds(), TimeUnit.SECONDS);
    }

    public String getNextReplica() {
        try {
            return this.replicas.next();
        }
        catch (NoSuchElementException e) {
            LOGGER.log(Level.WARNING, String.format("Could not find any read replicas. Returning the read only endpoint ([%s]) to fallback on Aurora balancing", this.readOnlyEndpoint));
            return this.readOnlyEndpoint;
        }
    }

    public class AuroraReplicasFinder
    implements Runnable {
        private final AmazonRDSAsync client;
        private final String clusterId;

        public AuroraReplicasFinder(String clusterId, AWSCredentialsProvider credentialsProvider, Region region) {
            this.clusterId = clusterId;
            LOGGER.log(Level.INFO, "Cluster ID: {0}", clusterId);
            LOGGER.log(Level.INFO, "AWS Region: {0}", region);
            this.client = (AmazonRDSAsync)((AmazonRDSAsyncClientBuilder)((AmazonRDSAsyncClientBuilder)AmazonRDSAsyncClient.asyncBuilder().withRegion(region.getName())).withCredentials(credentialsProvider)).build();
        }

        private Optional<DBCluster> describeCluster() {
            DescribeDBClustersResult describeDBClustersResult = this.client.describeDBClusters(new DescribeDBClustersRequest().withDBClusterIdentifier(this.clusterId));
            return describeDBClustersResult.getDBClusters().stream().findFirst();
        }

        private List<String> replicaMembersOf(DBCluster cluster) {
            List readReplicas = cluster.getDBClusterMembers().stream().filter(member -> member.isClusterWriter() == false).collect(Collectors.toList());
            ArrayList<String> urls = new ArrayList<String>(readReplicas.size());
            for (DBClusterMember readReplica : readReplicas) {
                String dbInstanceIdentifier = readReplica.getDBInstanceIdentifier();
                LOGGER.log(Level.FINE, String.format("Found read replica in cluster [%s]: [%s])", this.clusterId, dbInstanceIdentifier));
                DescribeDBInstancesResult describeDBInstancesResult = this.client.describeDBInstances(new DescribeDBInstancesRequest().withDBInstanceIdentifier(dbInstanceIdentifier));
                if (describeDBInstancesResult.getDBInstances().size() != 1) {
                    LOGGER.log(Level.WARNING, String.format("Got [%s] database instances for identifier [%s] (member of cluster [%s]). This is unexpected. Skipping.", describeDBInstancesResult.getDBInstances().size(), dbInstanceIdentifier, this.clusterId));
                    continue;
                }
                DBInstance readerInstance = (DBInstance)describeDBInstancesResult.getDBInstances().get(0);
                Endpoint endpoint = readerInstance.getEndpoint();
                if (!AuroraReadonlyEndpoint.ACTIVE_STATUS.equalsIgnoreCase(readerInstance.getDBInstanceStatus())) {
                    LOGGER.warning(String.format("Found [%s] as a replica for [%s] but its status is [%s]. Only replicas with status of [%s] are accepted. Skipping", dbInstanceIdentifier, this.clusterId, readerInstance.getDBInstanceStatus(), AuroraReadonlyEndpoint.ACTIVE_STATUS));
                    continue;
                }
                if (endpoint == null) {
                    LOGGER.log(Level.WARNING, String.format("Found [%s] as a replica for [%s] but it does not have a reachable address. Maybe it is still being created. Skipping", dbInstanceIdentifier, this.clusterId));
                    continue;
                }
                String endPointAddress = endpoint.getAddress();
                LOGGER.log(Level.FINE, String.format("Accepted instance with id [%s] with URL=[%s] to cluster [%s]", dbInstanceIdentifier, endPointAddress, this.clusterId));
                urls.add(endPointAddress);
            }
            return urls;
        }

        @Override
        public void run() {
            try {
                Optional<DBCluster> dbClusterOptional = this.describeCluster();
                if (!dbClusterOptional.isPresent()) {
                    LOGGER.log(Level.WARNING, String.format("Could not retrieve cluster information for cluster [%s]. Will fallback to [%s] until individual members can be retrieved again", this.clusterId, AuroraReadonlyEndpoint.this.readOnlyEndpoint));
                    return;
                }
                List readerUrls = dbClusterOptional.map(cluster -> this.replicaMembersOf((DBCluster)cluster)).orElse(new ArrayList(0));
                AuroraReadonlyEndpoint.this.replicas = RandomisedCyclicIterator.of(readerUrls);
                if (readerUrls.size() == 0) {
                    LOGGER.log(Level.WARNING, "No read replicas found for cluster [{0}]. Will fallback to [{1}] until individual members can be retrieved again", new Object[]{this.clusterId, AuroraReadonlyEndpoint.this.readOnlyEndpoint});
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, String.format("Retrieved [%s] read replicas for cluster id [%s] with. List will be refreshed in [%s] seconds", readerUrls.size(), this.clusterId, AuroraReadonlyEndpoint.this.pollerInterval.getSeconds()));
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, String.format("Exception while refreshing list of read replicas from cluster [%s]. Skipping", this.clusterId), e);
            }
        }

        public void init() {
            Optional<DBCluster> dbClusterOptional = this.describeCluster();
            if (!dbClusterOptional.isPresent()) {
                throw new RuntimeException(String.format("Could not find exactly one cluster with cluster id [%s]", this.clusterId));
            }
            DBCluster cluster = dbClusterOptional.get();
            AuroraReadonlyEndpoint.this.readOnlyEndpoint = cluster.getReaderEndpoint();
            List<String> readerUrls = this.replicaMembersOf(cluster);
            AuroraReadonlyEndpoint.this.replicas = RandomisedCyclicIterator.of(readerUrls);
            LOGGER.log(Level.INFO, String.format("Initialized driver for cluster id [%s] with [%s] read replicas. List will be refreshed every [%s] seconds", this.clusterId, readerUrls.size(), AuroraReadonlyEndpoint.this.pollerInterval.getSeconds()));
        }
    }
}

