/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicefairlink.iterators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class RandomisedCyclicIterator<T>
implements Iterator<T> {
    private final List<T> elements;
    private Iterator<T> iterator;

    protected RandomisedCyclicIterator(Collection<? extends T> collection) {
        this.elements = new ArrayList<T>(collection);
        Collections.shuffle(this.elements, ThreadLocalRandom.current());
        this.iterator = this.elements.iterator();
    }

    public static <T> RandomisedCyclicIterator<T> of(Collection<? extends T> collection) {
        return new RandomisedCyclicIterator<T>(collection);
    }

    @Override
    public boolean hasNext() {
        return !this.elements.isEmpty();
    }

    public boolean hasSameContent(Collection<T> externalElements) {
        if (externalElements == null || externalElements.size() != this.elements.size()) {
            return false;
        }
        return ((Stream)externalElements.stream().unordered()).allMatch(this.foundInInternalCollection());
    }

    private Predicate<T> foundInInternalCollection() {
        return externalElement -> this.elements.contains(externalElement);
    }

    @Override
    public synchronized T next() {
        if (!this.iterator.hasNext()) {
            this.iterator = this.elements.iterator();
            if (!this.iterator.hasNext()) {
                throw new NoSuchElementException();
            }
        }
        T next = this.iterator.next();
        return next;
    }
}

