/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicefairlink.driver;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FairlinkConnectionString {
    private static final String DRIVER_PROTOCOL = "fairlink";
    private static final Pattern driverPattern = Pattern.compile("jdbc:fairlink:(?<delegate>[^:]*):(?<uri>.*\\/\\/.+)");
    private static final String JDBC_PREFIX = "jdbc";
    private final String delegateProtocol;
    private final String fairlinKUri;
    private final URI delegateUri;
    private final Properties properties;

    public FairlinkConnectionString(String connectionString, Properties properties) throws URISyntaxException {
        this.fairlinKUri = connectionString;
        this.properties = properties;
        Matcher matcher = driverPattern.matcher(connectionString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(connectionString + " is not a valid fairlink connection string");
        }
        this.delegateProtocol = matcher.group("delegate");
        this.delegateUri = new URI(this.delegateProtocol + ":" + matcher.group("uri"));
    }

    public String getDelegateProtocol() {
        return this.delegateProtocol;
    }

    public String delegateConnectionString() {
        return "jdbc:" + this.delegateUri.toASCIIString();
    }

    public String delegateConnectionString(String forHost) throws URISyntaxException {
        URI portExtractor = new URI("jdbc://" + forHost);
        return new URI("jdbc:" + this.delegateUri.getScheme(), this.delegateUri.getUserInfo(), portExtractor.getHost(), portExtractor.getPort() == -1 ? this.delegateUri.getPort() : portExtractor.getPort(), this.delegateUri.getPath(), this.delegateUri.getQuery(), this.delegateUri.getFragment()).toASCIIString();
    }

    public String getHost() {
        return this.delegateUri.getHost();
    }

    public String getFairlinkUri() {
        return this.fairlinKUri;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public static boolean accepts(String url) {
        Matcher matcher = driverPattern.matcher(url);
        return matcher.matches();
    }
}

