/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicefairlink.discovery.members;

import java.util.Objects;
import java.util.Set;

public final class ClusterInfo {
    private final String readonlyEndpoint;
    private final Set<String> replicas;

    public ClusterInfo(String readonlyEndpoint, Set<String> replicas) {
        if ("".equals(readonlyEndpoint) || readonlyEndpoint == null) {
            throw new IllegalArgumentException("Read only endpoint must not be null");
        }
        if (replicas == null) {
            throw new IllegalArgumentException("Set of replicas must not be mull");
        }
        this.readonlyEndpoint = readonlyEndpoint;
        this.replicas = replicas;
    }

    public String getReadonlyEndpoint() {
        return this.readonlyEndpoint;
    }

    public Set<String> getReplicas() {
        return this.replicas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClusterInfo)) {
            return false;
        }
        ClusterInfo that = (ClusterInfo)o;
        return Objects.equals(this.getReadonlyEndpoint(), that.getReadonlyEndpoint()) && Objects.equals(this.getReplicas(), that.getReplicas());
    }

    public int hashCode() {
        return Objects.hash(this.getReadonlyEndpoint(), this.getReplicas());
    }
}

