/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicefairlink.discovery.members.awsapi;

import java.net.URI;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.RdsClientBuilder;
import software.amazon.awssdk.services.rds.model.DBCluster;
import software.amazon.awssdk.services.rds.model.DBClusterMember;
import software.amazon.awssdk.services.rds.model.DescribeDbClustersRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClustersResponse;
import technology.dice.dicefairlink.config.FairlinkConfiguration;
import technology.dice.dicefairlink.discovery.members.ClusterInfo;
import technology.dice.dicefairlink.discovery.members.MemberFinderMethod;
import technology.dice.dicefairlink.driver.FairlinkConnectionString;

public class AwsApiReplicasFinder
implements MemberFinderMethod {
    private static final Logger LOGGER = Logger.getLogger(AwsApiReplicasFinder.class.getName());
    private final String clusterId;
    private final RdsClient client;

    public AwsApiReplicasFinder(FairlinkConfiguration fairlinkConfiguration, FairlinkConnectionString fairlinkConnectionString) {
        this.clusterId = fairlinkConnectionString.getHost();
        LOGGER.log(Level.INFO, "Cluster ID: {0}", fairlinkConnectionString.getHost());
        LOGGER.log(Level.INFO, "AWS Region: {0}", fairlinkConfiguration.getAuroraClusterRegion());
        RdsClientBuilder clientBuilder = (RdsClientBuilder)((RdsClientBuilder)RdsClient.builder().region(fairlinkConfiguration.getAuroraClusterRegion())).credentialsProvider(fairlinkConfiguration.getAwsCredentialsProvider());
        fairlinkConfiguration.getAwsEndpointOverride().ifPresent(o -> {
            RdsClientBuilder cfr_ignored_0 = (RdsClientBuilder)clientBuilder.endpointOverride(URI.create(o));
        });
        this.client = (RdsClient)clientBuilder.build();
    }

    private DBCluster describeCluster(String clusterId) {
        DescribeDbClustersResponse describeDbClustersResponse = this.client.describeDBClusters((DescribeDbClustersRequest)DescribeDbClustersRequest.builder().dbClusterIdentifier(clusterId).build());
        return (DBCluster)describeDbClustersResponse.dbClusters().stream().findFirst().orElseThrow(() -> new RuntimeException(String.format("Could not find exactly one cluster with cluster id [%s]", clusterId)));
    }

    private Set<String> replicaMembersOf(DBCluster cluster) {
        Optional<DBClusterMember> writer = cluster.dbClusterMembers().stream().filter(member -> member.isClusterWriter()).findAny();
        Set<String> replicaIds = cluster.dbClusterMembers().stream().filter(dbClusterMember -> AwsApiReplicasFinder.isDbWriter(writer, dbClusterMember)).map(dbClusterMember -> dbClusterMember.dbInstanceIdentifier()).collect(Collectors.toSet());
        return replicaIds;
    }

    private static boolean isDbWriter(Optional<DBClusterMember> writer, DBClusterMember dbInstance) {
        return writer.map(w -> w.dbInstanceIdentifier().equalsIgnoreCase(dbInstance.dbInstanceIdentifier())).orElse(false) == false;
    }

    @Override
    public ClusterInfo discoverCluster() {
        DBCluster cluster = this.describeCluster(this.clusterId);
        return new ClusterInfo(cluster.readerEndpoint(), this.replicaMembersOf(cluster));
    }
}

