/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicefairlink;

import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import technology.dice.dicefairlink.config.FairlinkConfiguration;
import technology.dice.dicefairlink.discovery.members.MemberFinder;
import technology.dice.dicefairlink.iterators.SizedIterator;

public class AuroraReadonlyEndpoint {
    private static final Logger LOGGER = Logger.getLogger(AuroraReadonlyEndpoint.class.getName());
    private final MemberFinder fairlinkMemberFinder;
    private volatile SizedIterator<String> replicas;
    private final AtomicReference<String> lastReplica = new AtomicReference();

    public AuroraReadonlyEndpoint(FairlinkConfiguration fairlinkConfiguration, MemberFinder fairlinkMemberFinder, ScheduledExecutorService replicaDiscoveryExecutor) {
        this.fairlinkMemberFinder = fairlinkMemberFinder;
        this.replicas = fairlinkMemberFinder.init();
        Duration startJitter = fairlinkConfiguration.randomBoundDelay();
        LOGGER.log(Level.INFO, "Starting cluster member discovery with {0} delay.", startJitter);
        replicaDiscoveryExecutor.scheduleAtFixedRate(() -> {
            this.replicas = fairlinkMemberFinder.discoverReplicas();
        }, fairlinkConfiguration.getReplicaPollInterval().plus(startJitter).getSeconds(), fairlinkConfiguration.getReplicaPollInterval().getSeconds(), TimeUnit.SECONDS);
    }

    public String getNextReplica() {
        String nextReplica = (String)this.replicas.next();
        LOGGER.finer("Obtained replica: " + nextReplica);
        if (nextReplica != null && nextReplica.equals(this.lastReplica.get()) && this.replicas.size() > 1) {
            nextReplica = (String)this.replicas.next();
        }
        this.lastReplica.set(nextReplica);
        return nextReplica;
    }

    public void refresh() {
        this.replicas = this.fairlinkMemberFinder.discoverReplicas();
    }
}

