/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicefairlink.discovery.members;

import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import technology.dice.dicefairlink.config.FairlinkConfiguration;
import technology.dice.dicefairlink.discovery.members.ClusterInfo;
import technology.dice.dicefairlink.discovery.members.MemberFinder;
import technology.dice.dicefairlink.discovery.members.MemberFinderMethod;
import technology.dice.dicefairlink.discovery.members.ReplicaValidator;
import technology.dice.dicefairlink.discovery.tags.ExclusionTag;
import technology.dice.dicefairlink.discovery.tags.TagFilter;
import technology.dice.dicefairlink.driver.FairlinkConnectionString;
import technology.dice.dicefairlink.iterators.SizedIterator;

public class FairlinkMemberFinder
implements MemberFinder {
    private static final Logger LOGGER = Logger.getLogger(FairlinkMemberFinder.class.getName());
    private static final ExclusionTag EXCLUSION_TAG = new ExclusionTag("Fairlink-Exclude", "true");
    private static final Set<String> EMPTY_SET = Collections.unmodifiableSet(new HashSet(0));
    private final FairlinkConfiguration fairlinkConfiguration;
    private final MemberFinderMethod memberFinder;
    private final ReplicaValidator replicaValidator;
    private final Function<Collection<String>, SizedIterator<String>> iteratorBuilder;
    private volatile Optional<String> fallbackEndpoint = Optional.empty();
    private volatile Collection<String> excludedInstanceIds = Collections.unmodifiableCollection(new HashSet(0));
    protected final FairlinkConnectionString fairlinkConnectionString;
    protected final TagFilter tagFilter;

    public FairlinkMemberFinder(FairlinkConfiguration fairlinkConfiguration, FairlinkConnectionString fairlinkConnectionString, ScheduledExecutorService tagsPollingExecutor, TagFilter excludedInstancesFinder, MemberFinderMethod memberFinder, Function<Collection<String>, SizedIterator<String>> stringSizedIteratorBuilder, ReplicaValidator replicaValidator) {
        this.fairlinkConnectionString = fairlinkConnectionString;
        this.fairlinkConfiguration = fairlinkConfiguration;
        this.tagFilter = excludedInstancesFinder;
        this.memberFinder = memberFinder;
        this.replicaValidator = replicaValidator;
        this.iteratorBuilder = stringSizedIteratorBuilder;
        this.fallbackEndpoint = fairlinkConfiguration.getFallbackEndpoint();
        Duration startJitter = fairlinkConfiguration.randomBoundDelay();
        LOGGER.info("Starting excluded members discovery with " + startJitter + " delay.");
        tagsPollingExecutor.scheduleAtFixedRate(() -> {
            this.excludedInstanceIds = this.safeExclusionsDiscovery();
        }, startJitter.getSeconds(), fairlinkConfiguration.getTagsPollerInterval().getSeconds(), TimeUnit.SECONDS);
    }

    private Set<String> safeExclusionsDiscovery() {
        try {
            return this.tagFilter.listExcludedInstances(EXCLUSION_TAG);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not discover exclusions; including all discovered instances", e);
            return EMPTY_SET;
        }
    }

    @Override
    public final SizedIterator<String> discoverReplicas() {
        try {
            long before = System.currentTimeMillis();
            ClusterInfo clusterInfo = this.memberFinder.discoverCluster();
            this.fallbackEndpoint = Optional.of(this.fairlinkConfiguration.getFallbackEndpoint().orElse(clusterInfo.getReadonlyEndpoint()));
            Set filteredReplicas = clusterInfo.getReplicas().stream().filter(db -> !this.excludedInstanceIds.contains(db)).filter(dbIdentifier -> !this.fairlinkConfiguration.isValidateConnection() || this.validate(this.fairlinkConfiguration.hostname((String)dbIdentifier))).map(this.fairlinkConfiguration::hostname).collect(Collectors.toSet());
            SizedIterator<String> result = filteredReplicas.isEmpty() ? this.iteratorBuilder.apply(this.setOf(this.fallbackEndpoint.orElse(clusterInfo.getReadonlyEndpoint()))) : this.iteratorBuilder.apply(filteredReplicas);
            long after = System.currentTimeMillis();
            LOGGER.info("Updated list of replicas in " + (after - before) + " ms. Found " + filteredReplicas.size() + " good, active, non-excluded replica" + (filteredReplicas.size() != 1 ? "s" : "") + " (validation " + (this.fairlinkConfiguration.isValidateConnection() ? "" : "NOT ") + "done). Excluded " + this.excludedInstanceIds.size() + " instance" + (this.excludedInstanceIds.size() != 1 ? "s" : "") + (this.excludedInstanceIds.size() != 1 ? "" : "s") + ". Next update in " + this.fairlinkConfiguration.getReplicaPollInterval());
            return result;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error discovering cluster identified by [" + this.fairlinkConnectionString.getFairlinkUri() + "]. Will return fallback endpoint " + this.fallbackEndpoint.orElse("N/A") + " if available", e);
            if (!this.fallbackEndpoint.isPresent()) {
                LOGGER.log(Level.SEVERE, "Fallback endpoint not available. This means the cluster has never been successfully discovered. This is probably a permanent error condition");
            }
            return this.fallbackEndpoint.map(fallbackEndpoint -> this.iteratorBuilder.apply(this.setOf((String)fallbackEndpoint))).orElseThrow(() -> new RuntimeException("Could not discover cluster identified by [" + this.fairlinkConnectionString.getFairlinkUri() + "] and a fallback reader endpoint is not available"));
        }
    }

    private Set<String> setOf(String entry) {
        HashSet<String> set = new HashSet<String>(1);
        set.add(entry);
        return Collections.unmodifiableSet(set);
    }

    private boolean validate(String host) {
        try {
            return this.replicaValidator.isValid(this.fairlinkConnectionString.delegateConnectionString(host), this.fairlinkConnectionString.getProperties());
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    @Override
    public final SizedIterator<String> init() {
        this.excludedInstanceIds = this.safeExclusionsDiscovery();
        SizedIterator<String> replicasIterator = this.discoverReplicas();
        LOGGER.log(Level.INFO, String.format("Initialised driver for cluster identified by [%s with [%d] replicas]. List will be refreshed every [%s]", this.fairlinkConnectionString.getHost(), replicasIterator.size(), this.fairlinkConfiguration.getReplicaPollInterval()));
        return replicasIterator;
    }
}

