/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicefairlink.discovery.tags.awsapi;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.resourcegroupstaggingapi.ResourceGroupsTaggingApiClient;
import software.amazon.awssdk.services.resourcegroupstaggingapi.ResourceGroupsTaggingApiClientBuilder;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.GetResourcesRequest;
import software.amazon.awssdk.services.resourcegroupstaggingapi.paginators.GetResourcesIterable;
import technology.dice.dicefairlink.config.FairlinkConfiguration;
import technology.dice.dicefairlink.discovery.tags.ExclusionTag;
import technology.dice.dicefairlink.discovery.tags.TagFilter;

public class ResourceGroupApiTagDiscovery
implements TagFilter {
    private static final Logger LOGGER = Logger.getLogger(ResourceGroupApiTagDiscovery.class.getName());
    private static final String RDS_DB_INSTANCE_FILTER = "rds:db";
    private final ResourceGroupsTaggingApiClient client;
    private final Collection<String> typeFilter;

    public ResourceGroupApiTagDiscovery(FairlinkConfiguration fairlinkConfiguration) {
        ResourceGroupsTaggingApiClientBuilder clientBuilder = (ResourceGroupsTaggingApiClientBuilder)((ResourceGroupsTaggingApiClientBuilder)ResourceGroupsTaggingApiClient.builder().region(fairlinkConfiguration.getAuroraClusterRegion())).credentialsProvider(fairlinkConfiguration.getAwsCredentialsProvider());
        fairlinkConfiguration.getAwsEndpointOverride().ifPresent(o -> {
            ResourceGroupsTaggingApiClientBuilder cfr_ignored_0 = (ResourceGroupsTaggingApiClientBuilder)clientBuilder.endpointOverride(URI.create(o));
        });
        this.client = (ResourceGroupsTaggingApiClient)clientBuilder.build();
        ArrayList<String> temporaryTypeFilter = new ArrayList<String>(1);
        temporaryTypeFilter.add(RDS_DB_INSTANCE_FILTER);
        this.typeFilter = Collections.unmodifiableCollection(temporaryTypeFilter);
    }

    @Override
    public Set<String> listExcludedInstances(ExclusionTag tags) {
        try {
            GetResourcesRequest request = (GetResourcesRequest)GetResourcesRequest.builder().resourceTypeFilters(this.typeFilter).tagFilters(new software.amazon.awssdk.services.resourcegroupstaggingapi.model.TagFilter[]{(software.amazon.awssdk.services.resourcegroupstaggingapi.model.TagFilter)software.amazon.awssdk.services.resourcegroupstaggingapi.model.TagFilter.builder().key(tags.getKey()).values(new String[]{tags.getValue()}).build()}).build();
            GetResourcesIterable resourcesPaginator = this.client.getResourcesPaginator(request);
            Set<String> excludedDbInstances = resourcesPaginator.stream().flatMap(p -> p.resourceTagMappingList().stream().map(e -> e.resourceARN().substring(e.resourceARN().lastIndexOf(":") + 1))).collect(Collectors.toSet());
            LOGGER.fine("Found " + excludedDbInstances.size() + " excluded replica" + (excludedDbInstances.size() != 1 ? "s" : "") + " in the account, across all clusters");
            return excludedDbInstances;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to obtain excluded instances. All instances assumed not to be excluded", e);
            return Collections.unmodifiableSet(new HashSet(0));
        }
    }
}

