/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicewhere.downloader.source.s3;

import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import technology.dice.dicewhere.downloader.destination.FileAcceptor;
import technology.dice.dicewhere.downloader.exception.DownloaderException;
import technology.dice.dicewhere.downloader.files.FileInfo;
import technology.dice.dicewhere.downloader.files.S3FileInfo;
import technology.dice.dicewhere.downloader.md5.MD5Checksum;
import technology.dice.dicewhere.downloader.source.FileSource;

public class S3Source
implements FileSource {
    private static Logger LOG = LoggerFactory.getLogger(S3Source.class);
    public static final String MD5_METADATA_KEY = "md5";
    public static final String TIMESTAMP_METADATA_KEY = "ts";
    private final S3Client client;
    private final String bucket;
    private final String key;
    private FileInfo fileInfo;

    public S3Source(S3Client s3Client, String bucket, String key) {
        this.client = s3Client;
        this.bucket = bucket;
        this.key = key;
    }

    @Override
    public FileInfo fileInfo() {
        if (this.fileInfo == null) {
            HeadObjectRequest headObjectRequest = (HeadObjectRequest)HeadObjectRequest.builder().key(this.key).bucket(this.bucket).build();
            HeadObjectResponse headObjectResponse = this.client.headObject(headObjectRequest);
            Map metadata = headObjectResponse.metadata();
            if (!metadata.containsKey(MD5_METADATA_KEY)) {
                throw new DownloaderException("Remote file does not have md5 information. Please delete the file and re-upload");
            }
            if (!metadata.containsKey(TIMESTAMP_METADATA_KEY)) {
                LOG.warn("Timestamp not available at source. Using now as timestamp.");
            }
            long size = headObjectResponse.contentLength();
            this.fileInfo = new S3FileInfo(this.bucket, this.key, Optional.ofNullable(metadata.get(TIMESTAMP_METADATA_KEY)).map(m -> Instant.ofEpochMilli(Long.valueOf(m))).orElse(Instant.now()), MD5Checksum.of((String)metadata.get(MD5_METADATA_KEY)), size);
        }
        return this.fileInfo;
    }

    /*
     * Exception decompiling
     */
    @Override
    public MD5Checksum produce(FileAcceptor consumer) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

