/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicewhere.building;

import com.google.common.collect.Queues;
import com.google.protobuf.ByteString;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.mapdb.DB;
import org.mapdb.DBException;
import org.mapdb.DBMaker;
import org.mapdb.Serializer;
import org.mapdb.serializer.GroupSerializer;
import technology.dice.dicewhere.api.api.IP;
import technology.dice.dicewhere.api.api.IpInformation;
import technology.dice.dicewhere.building.DatabaseBuilderListener;
import technology.dice.dicewhere.building.IPDatabase;
import technology.dice.dicewhere.decorator.Decorator;
import technology.dice.dicewhere.decorator.DecoratorInformation;
import technology.dice.dicewhere.lineprocessing.SerializedLine;
import technology.dice.dicewhere.lineprocessing.serializers.IPSerializer;
import technology.dice.dicewhere.lineprocessing.serializers.protobuf.IPInformationProto;
import technology.dice.dicewhere.provider.ProviderKey;
import technology.dice.dicewhere.utils.ProtoValueConverter;

public class DatabaseBuilder
implements Runnable {
    private final BlockingQueue<SerializedLine> source;
    private final DatabaseBuilderListener listener;
    private final ProviderKey provider;
    private final DB.TreeMapSink<IP, byte[]> sink;
    private boolean expectingMore;
    private int processedLines = 0;
    private final Decorator<? extends DecoratorInformation> decorator;

    public DatabaseBuilder(ProviderKey provider, BlockingQueue<SerializedLine> source, DatabaseBuilderListener listener, Decorator<? extends DecoratorInformation> decorator) {
        this(StorageMode.FILE, provider, source, listener, decorator);
    }

    public DatabaseBuilder(StorageMode storageMode, ProviderKey provider, BlockingQueue<SerializedLine> source, DatabaseBuilderListener listener) {
        this(storageMode, provider, source, listener, null);
    }

    public DatabaseBuilder(StorageMode storageMode, ProviderKey provider, BlockingQueue<SerializedLine> source, DatabaseBuilderListener listener, Decorator<? extends DecoratorInformation> decorator) {
        DB.TreeMapSink sink;
        this.source = source;
        this.expectingMore = true;
        this.listener = listener;
        this.provider = provider;
        DB db = this.createDB(storageMode);
        this.sink = sink = db.treeMap(Objects.requireNonNull(provider).name(), (GroupSerializer)new IPSerializer(), Serializer.BYTE_ARRAY).createFromSink();
        this.decorator = decorator;
    }

    @NotNull
    private DB createDB(StorageMode storageMode) {
        DB db;
        switch (storageMode) {
            case HEAP: {
                db = DBMaker.heapDB().checksumHeaderBypass().transactionEnable().make();
                break;
            }
            case HEAP_BYTE_ARRAY: {
                db = DBMaker.memoryDB().checksumHeaderBypass().transactionEnable().make();
                break;
            }
            case OFF_HEAP: {
                db = DBMaker.memoryDirectDB().checksumHeaderBypass().transactionEnable().make();
                break;
            }
            default: {
                db = DBMaker.tempFileDB().checksumHeaderBypass().fileLockDisable().fileMmapEnable().fileChannelEnable().transactionEnable().fileDeleteAfterClose().make();
            }
        }
        return db;
    }

    public void dontExpectMore() {
        this.expectingMore = false;
    }

    public int remainingLines() {
        return this.source.size();
    }

    public int processedLines() {
        return this.processedLines;
    }

    protected Optional<Decorator<? extends DecoratorInformation>> getDecorator() {
        return Optional.ofNullable(this.decorator);
    }

    @Override
    public void run() {
        while (this.expectingMore || this.source.size() > 0) {
            SerializedLine beingProcessed = null;
            ArrayList availableForAdding = new ArrayList(this.source.size());
            try {
                Queues.drain(this.source, availableForAdding, (int)this.source.size(), (long)1L, (TimeUnit)TimeUnit.NANOSECONDS);
                for (SerializedLine currentLine : availableForAdding) {
                    try {
                        beingProcessed = currentLine;
                        this.decorateEntry(currentLine.getParsedLine().getInfo()).forEach(i -> this.sink.put((Object)i.getStartOfRange(), (Object)this.buildIpProtobuf((IpInformation)i).toByteArray()));
                        ++this.processedLines;
                        this.listener.lineAdded(this.provider, currentLine);
                    }
                    catch (DBException.NotSorted e) {
                        this.listener.lineOutOfOrder(this.provider, beingProcessed, (Exception)((Object)e));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Database builder interrupted", e);
                    }
                }
            }
            catch (InterruptedException e) {
                this.listener.builderInterrupted(this.provider, e);
                throw new RuntimeException("Database builder interrupted", e);
            }
        }
    }

    private Stream<IpInformation> decorateEntry(IpInformation entry) throws UnknownHostException {
        if (this.getDecorator().isPresent()) {
            return this.getDecorator().get().decorate(entry);
        }
        return Stream.of(entry);
    }

    private IPInformationProto.IpInformationProto buildIpProtobuf(IpInformation input) {
        IPInformationProto.IpInformationProto.Builder messageBuilder = IPInformationProto.IpInformationProto.newBuilder().setCity(input.getCity().orElse("")).setGeonameId(input.getGeonameId().orElse("")).setCountryCodeAlpha2(input.getCountryCodeAlpha2()).setLeastSpecificDivision(input.getLeastSpecificDivision().orElse("")).setMostSpecificDivision(input.getMostSpecificDivision().orElse("")).setPostcode(input.getPostcode().orElse("")).setStartOfRange(ByteString.copyFrom((byte[])input.getStartOfRange().getBytes())).setEndOfRange(ByteString.copyFrom((byte[])input.getEndOfRange().getBytes())).setIsVpn(ProtoValueConverter.toThreeStateValue(input.isVpn().orElse(null)));
        input.getOriginalLine().ifPresent(messageBuilder::setOriginalLine);
        return messageBuilder.build();
    }

    public IPDatabase build() {
        return new IPDatabase((NavigableMap)this.sink.create());
    }

    public static enum StorageMode {
        HEAP,
        HEAP_BYTE_ARRAY,
        OFF_HEAP,
        FILE;

    }
}

