/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicewhere.provider.dbip.reading;

import java.io.IOException;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import technology.dice.dicewhere.building.DatabaseBuilder;
import technology.dice.dicewhere.decorator.Decorator;
import technology.dice.dicewhere.decorator.DecoratorInformation;
import technology.dice.dicewhere.parsing.LineParser;
import technology.dice.dicewhere.provider.ProviderKey;
import technology.dice.dicewhere.provider.dbip.DbIpProviderKey;
import technology.dice.dicewhere.reading.LineReader;

public abstract class DbIpLineReader
extends LineReader {
    private static final int BUFFER_SIZE = 0x100000;
    private final LineParser lineParser;
    private final Path csv;

    public DbIpLineReader(@NotNull Path csv) {
        this(csv, null);
    }

    public DbIpLineReader(@NotNull Path csv, @Nullable Decorator<? extends DecoratorInformation> decorator) {
        this(csv, decorator, DatabaseBuilder.StorageMode.FILE);
    }

    public DbIpLineReader(@NotNull Path csv, @Nullable Decorator<? extends DecoratorInformation> decorator, @NotNull DatabaseBuilder.StorageMode storageMode) {
        super(storageMode);
        this.lineParser = this.buildLineParser(decorator);
        this.csv = csv;
    }

    public abstract LineParser buildLineParser(Decorator<? extends DecoratorInformation> var1);

    @Override
    protected Stream<String> lines() throws IOException {
        return DbIpLineReader.bufferedReaderForPath(this.csv, 0x100000).lines();
    }

    @Override
    public ProviderKey provider() {
        return DbIpProviderKey.of();
    }

    @Override
    public LineParser parser() {
        return this.lineParser;
    }
}

