/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicewhere.reading;

import com.google.common.collect.Iterators;
import com.google.common.collect.Streams;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.SequenceInputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import technology.dice.dicewhere.building.DatabaseBuilder;
import technology.dice.dicewhere.building.DatabaseBuilderListener;
import technology.dice.dicewhere.building.IPDatabase;
import technology.dice.dicewhere.decorator.Decorator;
import technology.dice.dicewhere.decorator.DecoratorInformation;
import technology.dice.dicewhere.lineprocessing.LineProcessor;
import technology.dice.dicewhere.lineprocessing.LineProcessorListener;
import technology.dice.dicewhere.lineprocessing.LineprocessorListenerForProvider;
import technology.dice.dicewhere.lineprocessing.SerializedLine;
import technology.dice.dicewhere.parsing.LineParser;
import technology.dice.dicewhere.provider.ProviderKey;
import technology.dice.dicewhere.reading.LineReaderListener;
import technology.dice.dicewhere.reading.RawLine;

public abstract class LineReader {
    private static final int LINES_BUFFER = 100000;
    private final DatabaseBuilder.StorageMode storageMode;
    public static byte[] MAGIC_ZIP = new byte[]{80, 75, 3, 4};
    public static int MAGIG_GZIP = 65280;

    public LineReader() {
        this(DatabaseBuilder.StorageMode.FILE);
    }

    public LineReader(@NotNull DatabaseBuilder.StorageMode storageMode) {
        this.storageMode = storageMode;
    }

    public abstract ProviderKey provider();

    public abstract LineParser parser();

    protected abstract Stream<String> lines() throws IOException;

    private static boolean isZipFile(Path path) {
        byte[] buffer = new byte[MAGIC_ZIP.length];
        try {
            RandomAccessFile raf = new RandomAccessFile(path.toFile(), "r");
            raf.readFully(buffer);
            for (int i = 0; i < MAGIC_ZIP.length; ++i) {
                if (buffer[i] == MAGIC_ZIP[i]) continue;
                return false;
            }
            raf.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static boolean isGZipped(Path path) {
        int magic = 0;
        try (RandomAccessFile raf = new RandomAccessFile(path.toFile(), "r");){
            magic = raf.read() & 0xFF | raf.read() << 8 & MAGIG_GZIP;
        }
        catch (Throwable e) {
            return false;
        }
        return magic == 35615;
    }

    public static BufferedReader bufferedReaderForPath(Path path, int bufferSize) throws IOException {
        BufferedReader br;
        if (LineReader.isZipFile(path)) {
            ZipFile zipFile = new ZipFile(path.toFile());
            Enumeration zipEntries = Collections.enumeration(Streams.stream((Iterator)Iterators.forEnumeration(zipFile.entries())).map(ze -> {
                try {
                    return zipFile.getInputStream((ZipEntry)ze);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }).collect(Collectors.toCollection(ArrayList::new)));
            SequenceInputStream sequenceInputStream = new SequenceInputStream(zipEntries);
            br = new BufferedReader(new InputStreamReader((InputStream)sequenceInputStream, StandardCharsets.UTF_8));
        } else if (LineReader.isGZipped(path)) {
            GZIPInputStream is = new GZIPInputStream(new FileInputStream(path.toFile()));
            br = new BufferedReader(new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));
        } else {
            FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);
            br = new BufferedReader(Channels.newReader((ReadableByteChannel)channel, "UTF-8"), bufferSize);
        }
        return br;
    }

    public final IPDatabase read(boolean retainOriginalLine, LineReaderListener readerListener, LineProcessorListener processListener, DatabaseBuilderListener buildingListener, int workersCount) {
        long before = System.currentTimeMillis();
        ExecutorService parserExecutorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("parser-%d").build());
        ExecutorService setupExecutorService = Executors.newFixedThreadPool(2, new ThreadFactoryBuilder().setNameFormat("line-reader-setup-%d").build());
        try {
            ArrayBlockingQueue<SerializedLine> serializedLinesBuffer = new ArrayBlockingQueue<SerializedLine>(100000);
            LineProcessor processor = new LineProcessor(parserExecutorService, serializedLinesBuffer, this.parser(), retainOriginalLine, new LineprocessorListenerForProvider(this.provider(), processListener), workersCount);
            DatabaseBuilder databaseBuilder = this.parser().getDecorator().map(d -> new DatabaseBuilder(this.storageMode, this.provider(), (BlockingQueue<SerializedLine>)serializedLinesBuffer, buildingListener, (Decorator<? extends DecoratorInformation>)d)).orElseGet(() -> new DatabaseBuilder(this.storageMode, this.provider(), serializedLinesBuffer, buildingListener));
            Future<?> processorFuture = setupExecutorService.submit(processor);
            Future<?> databaseBuilderFuture = setupExecutorService.submit(databaseBuilder);
            this.publishLinesToProcessor(readerListener, before, processor);
            processor.markDataComplete();
            processorFuture.get();
            databaseBuilder.dontExpectMore();
            databaseBuilderFuture.get();
            parserExecutorService.shutdown();
            parserExecutorService.awaitTermination(1L, TimeUnit.HOURS);
            setupExecutorService.shutdown();
            readerListener.finished(this.provider(), databaseBuilder.processedLines(), System.currentTimeMillis() - before);
            IPDatabase iPDatabase = databaseBuilder.build();
            return iPDatabase;
        }
        catch (Exception e) {
            throw new RuntimeException("Line reader read failed", e);
        }
        finally {
            parserExecutorService.shutdown();
            setupExecutorService.shutdown();
        }
    }

    private void publishLinesToProcessor(LineReaderListener readerListener, long before, LineProcessor processor) throws IOException {
        long[] n = new long[]{0L};
        try (Stream<String> lines = this.lines();){
            lines.forEach(line -> {
                n[0] = n[0] + 1L;
                processor.addLine(new RawLine((String)line, n[0]));
                readerListener.lineRead(this.provider(), new RawLine((String)line, n[0]), System.currentTimeMillis() - before);
            });
        }
    }
}

