/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicewhere.building.maxmindnative;

import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.model.AbstractCountryResponse;
import com.maxmind.geoip2.model.AnonymousIpResponse;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.CountryResponse;
import java.net.InetAddress;
import java.util.Optional;
import technology.dice.dicewhere.api.api.IP;
import technology.dice.dicewhere.api.api.IpInformation;
import technology.dice.dicewhere.building.IPDatabase;

public class MaxmindNativeDatabase
implements IPDatabase {
    private static final String cityType = "GeoLite2-City";
    private static final String countryType = "GeoLite2-Country";
    private final DatabaseReader location;
    private final Optional<DatabaseReader> anonymous;

    public MaxmindNativeDatabase(DatabaseReader location, Optional<DatabaseReader> anonymous) {
        this.location = location;
        this.anonymous = anonymous;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Optional<IpInformation> get(IP ip) {
        try {
            AnonymousIpResponse anonymousIpResponse;
            InetAddress inetAddress = InetAddress.getByAddress(ip.getBytes());
            String databaseType = this.location.getMetadata().getDatabaseType();
            IpInformation.Builder ipInformationBuilder = IpInformation.builder().withStartOfRange(ip).withEndOfRange(ip);
            if (cityType.equalsIgnoreCase(databaseType)) {
                CityResponse cityResponse = this.location.city(inetAddress);
                if (cityResponse == null) return Optional.empty();
                this.populateWithCityResponse(cityResponse, ipInformationBuilder);
            } else {
                if (!countryType.equalsIgnoreCase(databaseType)) throw new RuntimeException("Database type " + databaseType + " not supported.");
                CountryResponse countryResponse = this.location.country(inetAddress);
                if (countryResponse == null) return Optional.empty();
                this.populateWithCountryResponse(countryResponse, ipInformationBuilder);
            }
            if (!this.anonymous.isPresent() || (anonymousIpResponse = this.anonymous.get().anonymousIp(inetAddress)) == null) return Optional.of(ipInformationBuilder.build());
            ipInformationBuilder.isVpn(anonymousIpResponse.isAnonymousVpn());
            return Optional.of(ipInformationBuilder.build());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void populateCommon(AbstractCountryResponse baseResponse, IpInformation.Builder ipInformationBuilder) {
        ipInformationBuilder.withCountryCodeAlpha2(baseResponse.getCountry().getIsoCode());
    }

    private void populateWithCityResponse(CityResponse cityResponse, IpInformation.Builder ipInformationBuilder) {
        this.populateCommon((AbstractCountryResponse)cityResponse, ipInformationBuilder);
        if (cityResponse.getCity() != null) {
            ipInformationBuilder.withCity(cityResponse.getCity().getName());
            ipInformationBuilder.withGeonameId(String.valueOf(cityResponse.getCity().getGeoNameId()));
        }
        if (cityResponse.getLeastSpecificSubdivision() != null) {
            ipInformationBuilder.withLeastSpecificDivision(cityResponse.getLeastSpecificSubdivision().getName());
        }
        if (cityResponse.getMostSpecificSubdivision() != null) {
            ipInformationBuilder.withMostSpecificDivision(cityResponse.getMostSpecificSubdivision().getName());
        }
        if (cityResponse.getPostal() != null) {
            ipInformationBuilder.withPostcode(cityResponse.getPostal().getCode());
        }
    }

    private void populateWithCountryResponse(CountryResponse country, IpInformation.Builder ipInformationBuilder) {
        this.populateCommon((AbstractCountryResponse)country, ipInformationBuilder);
    }
}

