/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicewhere.lineprocessing;

import java.util.Objects;
import technology.dice.dicewhere.api.exceptions.LineParsingException;
import technology.dice.dicewhere.lineprocessing.LineProcessorListener;
import technology.dice.dicewhere.lineprocessing.SerializedLine;
import technology.dice.dicewhere.parsing.ParsedLine;
import technology.dice.dicewhere.provider.ProviderKey;
import technology.dice.dicewhere.reading.RawLine;

public class LineprocessorListenerForProvider {
    private final ProviderKey provider;
    private final LineProcessorListener listener;

    public LineprocessorListenerForProvider(ProviderKey provider, LineProcessorListener lineProcessingExceptionListener) {
        this.provider = Objects.requireNonNull(provider);
        this.listener = Objects.requireNonNull(lineProcessingExceptionListener);
    }

    public void enqueueError(RawLine rawLine, Exception e) {
        this.listener.enqueueError(this.provider, rawLine, e);
    }

    public void parseError(RawLine rawLine, LineParsingException e) {
        this.listener.parseError(this.provider, rawLine, e);
    }

    public void serializeError(ParsedLine parsedLine, Exception e) {
        this.listener.serializeError(this.provider, parsedLine, e);
    }

    public void dequeueError(SerializedLine serializedLine, Exception e) {
        this.listener.dequeueError(this.provider, serializedLine, e);
    }

    public void processorInterrupted(InterruptedException e) {
        this.listener.processorInterrupted(this.provider, e);
    }

    public void lineProcessed(SerializedLine serializedLine, long timeElapsed) {
        this.listener.lineProcessed(this.provider, serializedLine, timeElapsed);
    }

    public void lineParsed(ParsedLine parsed, long timeElapsed) {
        this.listener.lineParsed(this.provider, parsed, timeElapsed);
    }

    void finished(long totalLines, long timeElapsed) {
        this.listener.finished(this.provider, totalLines, timeElapsed);
    }
}

