/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicewhere.provider.maxmind.decorator;

import com.google.common.base.Splitter;
import inet.ipaddr.IPAddressString;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Optional;
import technology.dice.dicewhere.api.api.IP;
import technology.dice.dicewhere.decorator.DecoratorDbReader;
import technology.dice.dicewhere.decorator.VpnDecoratorInformation;
import technology.dice.dicewhere.reading.CSVLineReader;
import technology.dice.dicewhere.utils.StringUtils;

public class MaxmindVpnDecoratorDbReader
extends DecoratorDbReader<VpnDecoratorInformation> {
    private static final int BUFFER_SIZE = 0x100000;
    private static final Splitter splitter = Splitter.on((String)",");
    private final BufferedReader ipV4AnonymousDatabase;
    private boolean ipV4DbExhausted = false;
    private final BufferedReader ipV6AnonymousDatabase;

    public MaxmindVpnDecoratorDbReader(Path ipV4AnonymousDatabase, Path ipV6AnonymousDatabase) throws IOException {
        this(CSVLineReader.bufferedReaderForPath(ipV4AnonymousDatabase, 0x100000), CSVLineReader.bufferedReaderForPath(ipV6AnonymousDatabase, 0x100000));
    }

    public MaxmindVpnDecoratorDbReader(BufferedReader ipV4AnonymousDatabase, BufferedReader ipV6AnonymousDatabase) throws IOException {
        this.ipV4AnonymousDatabase = ipV4AnonymousDatabase;
        this.ipV6AnonymousDatabase = ipV6AnonymousDatabase;
        this.ipV4AnonymousDatabase.readLine();
        this.ipV6AnonymousDatabase.readLine();
        this.readNextLine().ifPresent(this::setLastFetched);
    }

    private Optional<String> readLine() throws IOException {
        if (!this.ipV4DbExhausted) {
            Optional<String> line = Optional.ofNullable(this.ipV4AnonymousDatabase.readLine());
            if (!line.isPresent()) {
                this.ipV4DbExhausted = true;
            } else {
                return line;
            }
        }
        return Optional.ofNullable(this.ipV6AnonymousDatabase.readLine());
    }

    @Override
    protected Optional<VpnDecoratorInformation> readNextLine() {
        try {
            if (this.ipV4AnonymousDatabase != null && this.ipV6AnonymousDatabase != null) {
                Optional<String> readLine;
                while ((readLine = this.readLine()).isPresent()) {
                    Optional<VpnDecoratorInformation> parsedLine = readLine.flatMap(this::parseDbLine);
                    if (!parsedLine.isPresent()) continue;
                    return parsedLine;
                }
                return Optional.empty();
            }
        }
        catch (IOException e) {
            return Optional.empty();
        }
        return Optional.empty();
    }

    @Override
    protected Optional<VpnDecoratorInformation> parseDbLine(String line) {
        Iterator fieldsIterator = splitter.split((CharSequence)line).iterator();
        String range = StringUtils.removeQuotes((String)fieldsIterator.next());
        IPAddressString rangeString = new IPAddressString(range);
        if (rangeString.getAddress() == null) {
            return Optional.empty();
        }
        IP l = new IP(rangeString.getAddress().getLower().getBytes());
        IP u = new IP(rangeString.getAddress().toMaxHost().getBytes());
        fieldsIterator.next();
        boolean isVpn = "1".equals(fieldsIterator.next());
        if (isVpn) {
            return Optional.of(new VpnDecoratorInformation(l, u));
        }
        return Optional.empty();
    }
}

