/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicewhere.provider.maxmind.reading;

import com.google.common.base.Splitter;
import java.io.BufferedReader;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import technology.dice.dicewhere.provider.maxmind.reading.MaxmindLocation;
import technology.dice.dicewhere.utils.StringUtils;

public class MaxmindLocationsParser {
    private final Splitter splitter = Splitter.on((String)",");

    public Map<String, MaxmindLocation> locations(BufferedReader reader) {
        try (Stream<String> lines = reader.lines();){
            Map<String, MaxmindLocation> map = lines.map(line -> {
                String leastSpecificDivision;
                Iterable fieldsIterable = this.splitter.split((CharSequence)line);
                Iterator fieldsIterator = fieldsIterable.iterator();
                String geonameId = (String)fieldsIterator.next();
                fieldsIterator.next();
                fieldsIterator.next();
                fieldsIterator.next();
                String countryCode = (String)fieldsIterator.next();
                if (fieldsIterator.hasNext()) {
                    fieldsIterator.next();
                }
                if (fieldsIterator.hasNext()) {
                    fieldsIterator.next();
                }
                String string = leastSpecificDivision = fieldsIterator.hasNext() ? (String)fieldsIterator.next() : "";
                if (fieldsIterator.hasNext()) {
                    fieldsIterator.next();
                }
                String mostSpecificDivision = fieldsIterator.hasNext() ? (String)fieldsIterator.next() : "";
                String city = fieldsIterator.hasNext() ? (String)fieldsIterator.next() : "";
                return new MaxmindLocation(StringUtils.removeQuotes(geonameId), StringUtils.removeQuotes(countryCode), StringUtils.removeQuotes(mostSpecificDivision), StringUtils.removeQuotes(leastSpecificDivision), StringUtils.removeQuotes(city));
            }).collect(Collectors.toMap(MaxmindLocation::getGeonameId, e -> e));
            return map;
        }
    }
}

