/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicewhere.api.api;

import com.google.common.collect.ImmutableMap;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import technology.dice.dicewhere.api.api.IP;
import technology.dice.dicewhere.api.api.IpInformation;
import technology.dice.dicewhere.api.exceptions.DuplicateProviderException;
import technology.dice.dicewhere.api.exceptions.NoProvidersException;
import technology.dice.dicewhere.api.exceptions.ProviderNotAvailableException;
import technology.dice.dicewhere.building.DatabaseBuilderListener;
import technology.dice.dicewhere.building.IPDatabase;
import technology.dice.dicewhere.lineprocessing.LineProcessorListener;
import technology.dice.dicewhere.provider.ProviderKey;
import technology.dice.dicewhere.reading.LineReaderListener;
import technology.dice.dicewhere.reading.SourceReader;

public class IPResolver {
    private static final int DEFAULT_LINE_PROCESSOR_WORKERS_COUNT = 4;
    private final Map<ProviderKey, IPDatabase> databases;

    private IPResolver(Map<ProviderKey, IPDatabase> databases) {
        this.databases = databases;
    }

    public CompletionStage<Optional<IpInformation>> resolveAsync(@Nonnull IP ip, @Nonnull ProviderKey provider) {
        return CompletableFuture.supplyAsync(() -> this.databases.get(Objects.requireNonNull(provider)).get(Objects.requireNonNull(ip)));
    }

    public CompletionStage<Optional<IpInformation>> resolveAsync(@Nonnull IP ip, @Nonnull ProviderKey provider, @Nonnull ExecutorService executorService) {
        return CompletableFuture.supplyAsync(() -> this.databases.get(Objects.requireNonNull(provider)).get(Objects.requireNonNull(ip)), Objects.requireNonNull(executorService));
    }

    public Optional<IpInformation> resolve(@Nonnull IP ip, @Nonnull ProviderKey provider) {
        if (!this.databases.containsKey(Objects.requireNonNull(provider))) {
            throw new ProviderNotAvailableException(String.format("Provider %s not available", provider.name()), provider);
        }
        return this.databases.get(Objects.requireNonNull(provider)).get(Objects.requireNonNull(ip));
    }

    public CompletionStage<Optional<IpInformation>> resolveAsync(@Nonnull String ip, @Nonnull ProviderKey provider) throws UnknownHostException {
        return this.resolveAsync(new IP(InetAddress.getByName(Objects.requireNonNull(ip))), Objects.requireNonNull(provider));
    }

    public CompletionStage<Optional<IpInformation>> resolveAsync(@Nonnull String ip, @Nonnull ProviderKey provider, @Nonnull ExecutorService executorService) throws UnknownHostException {
        return this.resolveAsync(new IP(InetAddress.getByName(Objects.requireNonNull(ip))), Objects.requireNonNull(provider), Objects.requireNonNull(executorService));
    }

    public Optional<IpInformation> resolve(@Nonnull String ip, @Nonnull ProviderKey provider) throws UnknownHostException {
        return this.resolve(new IP(InetAddress.getByName(Objects.requireNonNull(ip))), Objects.requireNonNull(provider));
    }

    public CompletionStage<Map<ProviderKey, Optional<IpInformation>>> resolveAsync(@Nonnull IP ip) {
        Map resolution = (Map)this.databases.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> this.resolveAsync(Objects.requireNonNull(ip), (ProviderKey)entry.getKey()).toCompletableFuture()));
        return CompletableFuture.allOf(resolution.values().toArray(new CompletableFuture[0])).thenApply(res -> (ImmutableMap)resolution.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> (Optional)((CompletableFuture)entry.getValue()).join())));
    }

    public Map<ProviderKey, Optional<IpInformation>> resolve(@Nonnull String ip) throws UnknownHostException {
        return this.resolve(new IP(InetAddress.getByName(Objects.requireNonNull(ip))));
    }

    public CompletionStage<Map<ProviderKey, Optional<IpInformation>>> resolveAsync(@Nonnull String ip) throws UnknownHostException {
        return this.resolveAsync(new IP(InetAddress.getByName(Objects.requireNonNull(ip))));
    }

    public Map<ProviderKey, CompletionStage<Optional<IpInformation>>> resolveAsync(@Nonnull String ip, @Nonnull ExecutorService executorService) throws UnknownHostException {
        return this.resolveAsync(new IP(InetAddress.getByName(Objects.requireNonNull(ip))), Objects.requireNonNull(executorService));
    }

    public Map<ProviderKey, CompletionStage<Optional<IpInformation>>> resolveAsync(@Nonnull IP ip, @Nonnull ExecutorService executorService) {
        Map<ProviderKey, CompletionStage<Optional<IpInformation>>> resolution = this.databases.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, databaseProviderIPDatabaseEntry -> this.resolveAsync(Objects.requireNonNull(ip), (ProviderKey)databaseProviderIPDatabaseEntry.getKey(), Objects.requireNonNull(executorService))));
        return resolution;
    }

    public Map<ProviderKey, Optional<IpInformation>> resolve(@Nonnull IP ip) {
        Map<ProviderKey, Optional<IpInformation>> resolution = this.databases.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, databaseProviderIPDatabaseEntry -> this.resolve(Objects.requireNonNull(ip), (ProviderKey)databaseProviderIPDatabaseEntry.getKey())));
        return resolution;
    }

    public static class Builder {
        private final Map<ProviderKey, SourceReader> providers;
        private boolean retainOriginalLine = false;
        private int workersCount = 4;
        private LineReaderListener readerListener = new LineReaderListener(){};
        private LineProcessorListener processorListener = new LineProcessorListener(){};
        private DatabaseBuilderListener builderListener = new DatabaseBuilderListener(){};

        public Builder() {
            this.providers = new HashMap<ProviderKey, SourceReader>();
        }

        public Builder withLineProcessorWorkersCount(int count) {
            this.workersCount = count;
            return this;
        }

        public Builder withProvider(@Nonnull SourceReader lineReader) {
            if (this.providers.containsKey(Objects.requireNonNull(lineReader).provider())) {
                throw new DuplicateProviderException(String.format("Provider %s has already been added", lineReader.provider().name()));
            }
            this.providers.put(lineReader.provider(), lineReader);
            return this;
        }

        public Builder retainOriginalLine(boolean retain) {
            this.retainOriginalLine = retain;
            return this;
        }

        public Builder withReaderListener(@Nonnull LineReaderListener readerListener) {
            this.readerListener = Objects.requireNonNull(readerListener);
            return this;
        }

        public Builder withProcessorListener(@Nonnull LineProcessorListener processorListener) {
            this.processorListener = Objects.requireNonNull(processorListener);
            return this;
        }

        public Builder withBuilderListener(@Nonnull DatabaseBuilderListener builderListener) {
            this.builderListener = Objects.requireNonNull(builderListener);
            return this;
        }

        public IPResolver build() {
            this.checkSanity();
            HashMap<ProviderKey, IPDatabase> databases = new HashMap<ProviderKey, IPDatabase>(this.providers.size());
            for (SourceReader reader : this.providers.values()) {
                databases.put(reader.provider(), reader.read(this.retainOriginalLine, this.readerListener, this.processorListener, this.builderListener, this.workersCount));
            }
            return new IPResolver(databases);
        }

        private void checkSanity() {
            if (this.providers.isEmpty()) {
                throw new NoProvidersException("Must build with at least one provider");
            }
        }
    }
}

