/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicewhere.provider.maxmind.parsing;

import com.google.common.base.Splitter;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import technology.dice.dicewhere.api.api.IP;
import technology.dice.dicewhere.api.api.IpInformation;
import technology.dice.dicewhere.api.exceptions.LineParsingException;
import technology.dice.dicewhere.decorator.Decorator;
import technology.dice.dicewhere.decorator.DecoratorInformation;
import technology.dice.dicewhere.parsing.LineParser;
import technology.dice.dicewhere.provider.maxmind.reading.MaxmindLocation;
import technology.dice.dicewhere.reading.RawLine;
import technology.dice.dicewhere.utils.StringUtils;

public class MaxmindLineParser
extends LineParser {
    private final Splitter splitter = Splitter.on((String)",");
    private final Map<String, MaxmindLocation> locationDictionary;
    private final Decorator<? extends DecoratorInformation> decorator;

    public MaxmindLineParser(Map<String, MaxmindLocation> locationDictionary, Decorator<? extends DecoratorInformation> decorator) {
        this.decorator = decorator;
        this.locationDictionary = locationDictionary;
    }

    public MaxmindLineParser(Map<String, MaxmindLocation> locationDictionary) {
        this(locationDictionary, null);
    }

    @Override
    public Optional<Decorator<? extends DecoratorInformation>> getDecorator() {
        return Optional.ofNullable(this.decorator);
    }

    @Override
    protected IpInformation parseLine(RawLine rawLine, boolean retainOriginalLine) throws LineParsingException {
        try {
            IPAddressString rangeString;
            Iterable fieldsIterable = this.splitter.split((CharSequence)rawLine.getLine());
            Iterator fieldsIterator = fieldsIterable.iterator();
            String range = StringUtils.removeQuotes((String)fieldsIterator.next());
            String geonameId = (String)fieldsIterator.next();
            String geonameIdRepresented = (String)fieldsIterator.next();
            if (fieldsIterator.hasNext()) {
                fieldsIterator.next();
            }
            if (fieldsIterator.hasNext()) {
                fieldsIterator.next();
            }
            if (fieldsIterator.hasNext()) {
                fieldsIterator.next();
            }
            String postcode = fieldsIterator.hasNext() ? (String)fieldsIterator.next() : null;
            MaxmindLocation loc = this.locationDictionary.get(geonameId);
            if (loc == null) {
                loc = this.locationDictionary.get(geonameIdRepresented);
            }
            if (loc == null) {
                loc = MaxmindLocation.UNKNOWN;
            }
            if ((rangeString = new IPAddressString(range)).getAddress() == null) {
                throw new LineParsingException("Invalid IP range", rawLine);
            }
            IPAddress rangeStart = rangeString.getAddress().getLower();
            IPAddress rangeEnd = rangeString.getAddress().toMaxHost();
            return IpInformation.builder().withCountryCodeAlpha2(StringUtils.removeQuotes(loc.getCountryCodeAlpha2())).withGeonameId(StringUtils.removeQuotes(geonameId)).withCity(StringUtils.removeQuotes(loc.getCity())).withLeastSpecificDivision(StringUtils.removeQuotes(loc.getLeastSpecificDivision())).withMostSpecificDivision(StringUtils.removeQuotes(loc.getMostSpecificDivision())).withPostcode(StringUtils.removeQuotes(postcode)).withStartOfRange(new IP(rangeStart.getBytes())).withEndOfRange(new IP(rangeEnd.getBytes())).withOriginalLine(retainOriginalLine ? rawLine.getLine() : null).build();
        }
        catch (NoSuchElementException e) {
            throw new LineParsingException(e, rawLine);
        }
    }
}

