/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicewhere.building.maxmindnative;

import com.google.common.collect.ImmutableSet;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.AddressNotFoundException;
import com.maxmind.geoip2.model.AbstractCountryResponse;
import com.maxmind.geoip2.model.AnonymousIpResponse;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.CountryResponse;
import java.net.InetAddress;
import java.util.Optional;
import java.util.Set;
import technology.dice.dicewhere.api.api.IP;
import technology.dice.dicewhere.api.api.IpInformation;
import technology.dice.dicewhere.building.IPDatabase;
import technology.dice.dicewhere.building.maxmindnative.NativeDatabaseType;

public class MaxmindNativeDatabase
implements IPDatabase {
    private static final Set<String> cityTypes = ImmutableSet.of((Object)"GeoLite2-City", (Object)"GeoIP2-City");
    private static final Set<String> countryTypes = ImmutableSet.of((Object)"GeoLite2-Country", (Object)"GeoIP2-Country");
    private final DatabaseReader location;
    private final Optional<DatabaseReader> anonymous;
    private final NativeDatabaseType nativeDatabaseType;

    public MaxmindNativeDatabase(DatabaseReader location, Optional<DatabaseReader> anonymous) {
        this.location = location;
        this.anonymous = anonymous;
        String databaseType = location.getMetadata().getDatabaseType();
        if (cityTypes.contains(databaseType)) {
            this.nativeDatabaseType = NativeDatabaseType.CITY;
        } else if (countryTypes.contains(databaseType)) {
            this.nativeDatabaseType = NativeDatabaseType.COUNTRY;
        } else {
            throw new RuntimeException("Database type " + databaseType + " not supported.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Optional<IpInformation> get(IP ip) {
        try {
            AnonymousIpResponse anonymousIpResponse;
            InetAddress inetAddress = InetAddress.getByAddress(ip.getBytes());
            IpInformation.Builder ipInformationBuilder = IpInformation.builder().withStartOfRange(ip).withEndOfRange(ip);
            if (this.nativeDatabaseType == NativeDatabaseType.CITY) {
                CityResponse cityResponse = this.location.city(inetAddress);
                if (cityResponse == null || cityResponse.getCountry() == null || cityResponse.getCountry().getIsoCode() == null) return Optional.empty();
                this.populateWithCityResponse(cityResponse, ipInformationBuilder);
            } else {
                if (this.nativeDatabaseType != NativeDatabaseType.COUNTRY) throw new RuntimeException("Database type " + this.nativeDatabaseType.name() + " not supported.");
                CountryResponse countryResponse = this.location.country(inetAddress);
                if (countryResponse == null || countryResponse.getCountry() == null || countryResponse.getCountry().getIsoCode() == null) return Optional.empty();
                this.populateWithCountryResponse(countryResponse, ipInformationBuilder);
            }
            if (!this.anonymous.isPresent() || (anonymousIpResponse = this.anonymous.get().anonymousIp(inetAddress)) == null) return Optional.of(ipInformationBuilder.build());
            ipInformationBuilder.isHostingProvider(anonymousIpResponse.isHostingProvider());
            ipInformationBuilder.isVpn(anonymousIpResponse.isAnonymousVpn());
            return Optional.of(ipInformationBuilder.build());
        }
        catch (AddressNotFoundException e) {
            return Optional.empty();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void populateCommon(AbstractCountryResponse baseResponse, IpInformation.Builder ipInformationBuilder) {
        ipInformationBuilder.withCountryCodeAlpha2(baseResponse.getCountry().getIsoCode());
    }

    private void populateWithCityResponse(CityResponse cityResponse, IpInformation.Builder ipInformationBuilder) {
        this.populateCommon((AbstractCountryResponse)cityResponse, ipInformationBuilder);
        if (cityResponse.getCity() != null) {
            ipInformationBuilder.withCity(cityResponse.getCity().getName());
            ipInformationBuilder.withGeonameId(String.valueOf(cityResponse.getCity().getGeoNameId()));
        }
        if (cityResponse.getLeastSpecificSubdivision() != null) {
            ipInformationBuilder.withLeastSpecificDivision(cityResponse.getLeastSpecificSubdivision().getName());
        }
        if (cityResponse.getMostSpecificSubdivision() != null) {
            ipInformationBuilder.withMostSpecificDivision(cityResponse.getMostSpecificSubdivision().getName());
        }
        if (cityResponse.getPostal() != null) {
            ipInformationBuilder.withPostcode(cityResponse.getPostal().getCode());
        }
    }

    private void populateWithCountryResponse(CountryResponse country, IpInformation.Builder ipInformationBuilder) {
        this.populateCommon((AbstractCountryResponse)country, ipInformationBuilder);
    }
}

