/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicewhere.building.mmdb;

import com.maxmind.db.CHMCache;
import com.maxmind.db.NodeCache;
import com.maxmind.db.Reader;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import technology.dice.dicewhere.api.api.IP;
import technology.dice.dicewhere.api.api.IpInformation;
import technology.dice.dicewhere.building.mmdb.CityResult;
import technology.dice.dicewhere.building.mmdb.CountryResult;
import technology.dice.dicewhere.building.mmdb.LocationSource;
import technology.dice.dicewhere.building.mmdb.MmdbDatabaseType;

public abstract class MmdbLocationSource
implements LocationSource {
    private final Reader location;
    protected final MmdbDatabaseType mmdbDatabaseType;

    public MmdbLocationSource(Path path) {
        block4: {
            try {
                this.location = new Reader(new File(path.toFile().toURI()), (NodeCache)new CHMCache());
                String databaseType = this.location.getMetadata().getDatabaseType();
                if (this.supportedCityDatabaseTypes().contains(databaseType)) {
                    this.mmdbDatabaseType = MmdbDatabaseType.CITY;
                    break block4;
                }
                if (this.supportedCountryDatabaseTypes().contains(databaseType)) {
                    this.mmdbDatabaseType = MmdbDatabaseType.COUNTRY;
                    break block4;
                }
                throw new RuntimeException("Database type " + databaseType + " not supported.");
            }
            catch (IOException e) {
                throw new RuntimeException("Error accessing file " + path.toFile());
            }
        }
    }

    public abstract Set<String> supportedCityDatabaseTypes();

    public abstract Set<String> supportedCountryDatabaseTypes();

    public abstract Class<? extends CityResult> cityResult();

    public abstract Class<? extends CountryResult> countryResult();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Optional<IpInformation> resolve(IP ip) {
        try {
            InetAddress inetAddress = InetAddress.getByAddress(ip.getBytes());
            IpInformation.Builder ipInformationBuilder = IpInformation.builder().withStartOfRange(ip).withEndOfRange(ip);
            if (this.mmdbDatabaseType == MmdbDatabaseType.CITY) {
                CityResult cityResponse = (CityResult)this.location.get(inetAddress, this.cityResult());
                if (cityResponse == null || cityResponse.country() == null) return Optional.empty();
                this.populateWithCityResponse(cityResponse, ipInformationBuilder);
                return Optional.of(ipInformationBuilder.build());
            } else {
                if (this.mmdbDatabaseType != MmdbDatabaseType.COUNTRY) throw new RuntimeException("Database type " + this.mmdbDatabaseType.name() + " not supported.");
                CountryResult countryResponse = (CountryResult)this.location.get(inetAddress, this.countryResult());
                if (countryResponse == null || countryResponse.country() == null) return Optional.empty();
                this.populateWithCountryResponse(countryResponse, ipInformationBuilder);
            }
            return Optional.of(ipInformationBuilder.build());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void populateWithCityResponse(CityResult cityResponse, IpInformation.Builder ipInformationBuilder) {
        ipInformationBuilder.withCountryCodeAlpha2(cityResponse.country());
        if (cityResponse.city() != null) {
            ipInformationBuilder.withCity(cityResponse.city());
            ipInformationBuilder.withCityGeonameId(String.valueOf(cityResponse.geoNameId()));
        }
        if (cityResponse.leastSpecificDivision() != null) {
            ipInformationBuilder.withLeastSpecificDivision(cityResponse.leastSpecificDivision());
        }
        if (cityResponse.mostSpecificDivision() != null) {
            ipInformationBuilder.withMostSpecificDivision(cityResponse.mostSpecificDivision());
        }
        if (cityResponse.postal() != null) {
            ipInformationBuilder.withPostcode(cityResponse.postal());
        }
    }

    private void populateWithCountryResponse(CountryResult countryResponse, IpInformation.Builder ipInformationBuilder) {
        ipInformationBuilder.withCountryCodeAlpha2(countryResponse.country());
    }
}

