/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicewhere.building.mmdb;

import com.maxmind.db.CHMCache;
import com.maxmind.db.NodeCache;
import com.maxmind.db.Reader;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.Path;
import technology.dice.dicewhere.api.api.IP;
import technology.dice.dicewhere.api.api.IpInformation;
import technology.dice.dicewhere.building.mmdb.AnonymousResult;
import technology.dice.dicewhere.building.mmdb.AnonymousSource;

public abstract class MmdbAnonymousSource
implements AnonymousSource {
    private final Reader anonymous;

    public MmdbAnonymousSource(Path path) {
        try {
            this.anonymous = new Reader(new File(path.toFile().toURI()), (NodeCache)new CHMCache());
        }
        catch (IOException e) {
            throw new RuntimeException("Error accessing file " + String.valueOf(path.toFile()));
        }
    }

    public abstract Class<? extends AnonymousResult> anonymousResult();

    @Override
    public IpInformation withAnonymousInformation(IP ip, IpInformation ipInformation) {
        try {
            InetAddress inetAddress = InetAddress.getByAddress(ip.getBytes());
            AnonymousResult anonymousIpResponse = (AnonymousResult)this.anonymous.get(inetAddress, this.anonymousResult());
            if (anonymousIpResponse != null) {
                return IpInformation.builder(ipInformation).isHostingProvider(anonymousIpResponse.hostingProvider()).isVpn(anonymousIpResponse.vpn()).build();
            }
            return ipInformation;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

